/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * SNMP V3 msgIDێEǗNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SnmpV3MsgIDManager {
    /* Snmp V3 msgID */
    private static int msgID = 1;

    /* msgIDl */
    private static final int MSG_ID_LIMIT = 1000;

    /* msgIDL[ƂmsgIDCX^X(OIDێ)ێMap */
    private static Map msgIDMap = Collections.synchronizedMap(new HashMap());

    /*
     * RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
     *
     */
    private SnmpV3MsgIDManager() {
        // nothing
    }

    /**
     * msgIDɑΉmsgIDCX^X(OIDyThread)Ԃ܂B
     *
     * @param checkMsgID msgID
     * @return msgIDCX^X
     */
    public synchronized SnmpV3MsgID getMsgIDInstance(String checkMsgID) {
        return (SnmpV3MsgID) msgIDMap.get(checkMsgID);
    }

    /**
     * Snmp V3 msgIDJEgAbvĕԂ܂B
     *
     * @param theadName Thread
     * @param oid OID
     * @return msgID Snmp V3 msgID
     */
    public synchronized int getMsgID(String theadName, String oid) {
        // msgIDJEgAbv
        msgID++;

        if (msgID > MSG_ID_LIMIT) {
            msgID = 1;
        }

        /* msgIDCX^X */
        SnmpV3MsgID msgIDInstance = new SnmpV3MsgID();
        msgIDInstance.setThreadName(theadName);
        msgIDInstance.setOid(oid);

        /* msgIDL[ƂmsgIDCX^Xێ */
        msgIDMap.put(Integer.toString(msgID), msgIDInstance);

        return msgID;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpV3MsgIDManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpV3MsgIDManager RESOURCE = new SnmpV3MsgIDManager();
    }
}
