/*
 * Created on 2007/02/02
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.command.control.CommandMappingTableResource;

public class ConnectionNetworkPrinterInfo extends AbstractConnectionEngine {

	public ConnectionNetworkPrinterInfo(final String engineAddress) {
		super(engineAddress);
	}

	public ArrayList getPrintMibInfo(final String targetIPAddress)
			throws EngineConnectException, IOException {

		CommandInfo commandInfo = new CommandInfo();
		commandInfo
				.setCode(CommandMappingTableResource.NETWORK_PRINTER_COMMAND_ID);
		commandInfo.setIpaddress(targetIPAddress);

		ArrayList printMibInfoList = (ArrayList) this
				.communicationToEngine(commandInfo);
		return printMibInfoList;
	}
}
