/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.common;

import netjfwatcher.engine.socket.info.NodeInformation;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

/**
 * m[h Editor View̓͒lێNXłB m[hViewł́A̓͒lView̐ݒȂǂs܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorInputNodeView implements IEditorInput {
	/* View^Cg */
	private final String title;

	/* m[hĎ */
	private NodeInformation nodeInfo;

	/* lbg[NoRŃm[h擾邩ۂtO */
	private boolean isSocket;

	/* Editor ViewXV邩ۂtO */
	private boolean isRefresh;

	/* OID */
	private String oid;

	/**
	 * m[h Editor View̓͒lێNXCX^X ܂B
	 * 
	 * @param title
	 *            View^Cg
	 * @param isSocket
	 *            lbg[NoRŏ擾邩tO
	 */
	public EditorInputNodeView(String title, boolean isSocket) {
		this.title = title;
		this.isSocket = isSocket;
	}

	/**
	 * m[h Editor View̓͒lێNXCX^X ܂B
	 * 
	 * @param title
	 *            View^Cg
	 * @param nodeInfo
	 *            m[hĎ
	 * @param isSocket
	 *            lbg[NoRŏ擾邩tO
	 */
	public EditorInputNodeView(String title, NodeInformation nodeInfo,
			boolean isSocket) {
		this.title = title;
		this.nodeInfo = nodeInfo;
		this.isSocket = isSocket;
	}

	/**
	 * m[h Editor View̓͒lێNXCX^X ܂B
	 * 
	 * @param title
	 *            View^Cg
	 * @param nodeInfo
	 *            m[hĎ
	 * @param isSocket
	 *            lbg[NoRŏ擾邩tO
	 * @param isRefresh
	 *            Editor ViewXV邩ۂtO
	 */
	public EditorInputNodeView(String title, NodeInformation nodeInfo,
			boolean isSocket, boolean isRefresh) {
		this.title = title;
		this.isSocket = isSocket;
		this.nodeInfo = nodeInfo;
		this.isRefresh = isRefresh;
	}

	/**
	 * m[h Editor View̓͒lێNXCX^X ܂B
	 * 
	 * @param title
	 *            View^Cg
	 * @param nodeInfo
	 *            m[hĎ
	 * @param isSocket
	 *            lbg[NoR̎tO
	 * @param oid
	 *            OID
	 */
	public EditorInputNodeView(String title, NodeInformation nodeInfo,
			boolean isSocket, String oid) {
		this.title = title;
		this.nodeInfo = nodeInfo;
		this.isSocket = isSocket;
		this.oid = oid;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IEditorInput#getImageDescriptor()
	 */
	public ImageDescriptor getImageDescriptor() {
		return null;
	}

	/**
	 * ^CgԂ܂B
	 * 
	 * @return title ^Cg
	 */
	public String getName() {
		return title;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IEditorInput#getPersistable()
	 */
	public IPersistableElement getPersistable() {
		return null;
	}

	/**
	 * ToolTipTextƂă^CgԂ܂B
	 * 
	 * @return url URL
	 */
	public String getToolTipText() {
		return title;
	}

	/**
	 * ^Cgrēł邩Ԃ܂B
	 * 
	 * @param obj
	 *            Object
	 * @return ^Cgr
	 */
	public boolean equals(Object obj) {

		if (!(obj instanceof EditorInputNodeView)) {
			return false;
		}

		EditorInputNodeView that = (EditorInputNodeView) obj;

		return this.title.equals(that.title);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IEditorInput#exists()
	 */
	public boolean exists() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return title.hashCode();
	}

	/**
	 * m[hĎԂ܂B
	 * 
	 * @return nodeInfo m[hĎ
	 */
	public NodeInformation getNodeInfo() {
		return nodeInfo;
	}

	/**
	 * OIDԂ܂B
	 * 
	 * @return oid OID
	 */
	public String getOid() {
		return oid;
	}

	/**
	 * lbg[NoRŏ擾邩tOԂ܂B
	 * 
	 * @return isSocket lbg[NoRŏ擾邩tO
	 */
	public boolean isSocket() {
		return isSocket;
	}

	/**
	 * Editor ViewXV邩ۂtOԂ܂B
	 * 
	 * @return isRefresh Editor ViewXV邩ۂtO
	 */
	public boolean isRefresh() {
		return isRefresh;
	}

}
