/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.socket.ConnectionInterfaceMib;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionSystemMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceMib;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.SystemMib;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/**
 * m[hSnmpEditorPartɕ\ViewNXłB \SnmṕA System MIBInterface MIBłB
 * 
 * System MIBƂĕ\MIB͈ȉłB (1) sysDescr (2) sysUpTime (3) sysContact (4)
 * sysName (5) sysLocation
 * 
 * Interface MIBƂĕ\MIB͈ȉłB (1) ifNumber (2) ifIndex (3) ifDescr (4) ifType
 * (5) ifMtu (6) ifSpeed (7) ifPhysAddress (8) ifAdminStatus (9) ifOperStatus
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeSnmp extends AbstractEditorNodeView {
	/** m[hSnmp View title suffix */
	public static final String TITLE_SUFFIX = " Snmp View";

	/* eLXg */
	private static final int TEXT_WIDTH = 800;

	/* MO */
	private static Logger logger;

	/* Interface MIBe[u JRatio */
	private static final float COLUMN0_IFINDEX_RATIO = 0.04f;

	private static final float COLUMN1_IFDESC_RATIO = 0.1f;

	private static final float COLUMN2_IFTYPE_RATIO = 0.1f;

	private static final float COLUMN3_IFMTU_RATIO = 0.1f;

	private static final float COLUMN4_IFMSPEED_RATIO = 0.1f;

	private static final float COLUMN5_IFPHYSADDRESS_RATIO = 0.1f;

	private static final float COLUMN6_IFSTATUS_RATIO = 0.1f;

	private static Color BLUE_COLOR = new Color(null, 0, 0, 255);
	
	/* m[hĎ */
	private NodeInformation targetNodeInfo;

	/* sysDescr */
	private Text sysDescrText;

	/* sysUpTime */
	private Text sysUpTimeText;

	/* sysName */
	private Text sysNameText;

	/* sysContact */
	private Text sysContactText;

	/* sysLocation */
	private Text sysLocationText;

	/* m[hSNMP MIB̎{^ */
	private Button getMibButton;

	/* XV{^ */
	private Button refreshButton;

	/* Interface MIB\ TableViewer */
	private TableViewer viewer;

	/* Text BackColor */
	private Color textBackColor;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorNodeSnmp() {
		logger = Logger.getLogger(this.getClass().getName());

		/* Snmp System MIBTextBackground color */
		textBackColor = WHITE_COLOR;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();

		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("Node Input null");
		}

		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		refreshButton = new Button(composite, SWT.NONE);
		refreshButton.setText("Refresh");
		refreshButton.setLayoutData(new GridData());

		getMibButton = new Button(composite, SWT.NONE);
		getMibButton.setText("Node Get");
		getMibButton.setLayoutData(new GridData());

		/*
		 * Label label = new Label(composite, SWT.NONE); label.setText("");
		 * gridData = new GridData(); gridData.horizontalSpan = 1;
		 * gridData.verticalSpan = 1; label.setLayoutData(gridData);
		 */
		Label label = new Label(composite, SWT.NONE);
		label.setText("sysDescr");
		label.setLayoutData(new GridData());
		sysDescrText = new Text(composite, SWT.READ_ONLY);
		sysDescrText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		sysDescrText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("sysUpTime");
		label.setLayoutData(new GridData());
		sysUpTimeText = new Text(composite, SWT.READ_ONLY);
		sysUpTimeText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		sysUpTimeText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("sysContact");
		gridData = new GridData();
		label.setLayoutData(gridData);

		sysContactText = new Text(composite, SWT.READ_ONLY);
		sysContactText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		sysContactText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("sysName");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		sysNameText = new Text(composite, SWT.READ_ONLY);
		sysNameText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		sysNameText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("sysLocation");
		gridData = new GridData();
		label.setLayoutData(gridData);

		sysLocationText = new Text(composite, SWT.READ_ONLY);
		sysLocationText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		sysLocationText.setLayoutData(gridData);

		SystemMib systemMibInfo = null;
		ArrayList interfaceMibList = null;

		/*
		 * System MIBf[^x[X擾ăeLXg\
		 */
		systemMibInfo = getSystemMib(targetNodeInfo, false);

		/*
		 * wm[hInterface MIBf[^x[X擾
		 */
		interfaceMibList = getInterfaceMib(targetNodeInfo, false);

		setTextNodeInfo(systemMibInfo);

		/* Interface MIB\e[uZbg */
		SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
		table = statisticsTable.createTable(parent);

		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		/* Interface MIBXgɂăe[u\ */
		setInterfaceMibTable(interfaceMibList);

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				SystemMib systemMibInfo = getSystemMib(targetNodeInfo, true);
				setTextNodeInfo(systemMibInfo);

				/*
				 * wm[hInterface MIB擾
				 */
				ArrayList interfaceMibList = getInterfaceMib(targetNodeInfo,
						true);

				/* Interface MIBXgɂăe[u\ */
				setInterfaceMibTable(interfaceMibList);

				refreshButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * m[hSNMP MIB̎{^Xi[
		 */
		getMibButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				getMibButton.setEnabled(false);

				NodeInformation nodeInfo = getNodeInfo();

				getNodeSnmp(nodeInfo);
				getMibButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * m[hĎ擾ĕԂ܂B
	 * 
	 * @return m[hĎ
	 */
	private NodeInformation getNodeInfo() {
		NodeInformation nodeInfo = null;

		if (!isSocket) {
			DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
					.getInstance();

			try {
				ArrayList nodeList = nodeRegisterDBTable
						.findTarget(targetNodeInfo.getIpaddress());

				if (nodeList.size() > 0) {
					nodeInfo = (NodeInformation) nodeList.get(0);
				}
			} catch (SQLException e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return null;
			} catch (Exception e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return null;
			}
		} else {
			ArrayList nodeList = null;
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			try {
				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeList = connectNodeInfo.getNodeInformationList(null, null);
			} catch (EngineConnectException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e1
						.getMessage()
						+ " Engine = " + engineAddress);
				logger.warning("Node List import error" + e1.getMessage());
				shell.dispose();

				return null;
			} catch (IOException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e1
						.getMessage()
						+ " Engine = " + engineAddress);
				logger.warning("Node List import error" + e1.getMessage());
				shell.dispose();

				return null;
			}

			if (nodeList.size() > 0) {
				nodeInfo = (NodeInformation) nodeList.get(0);
			}
		}

		return nodeInfo;
	}

	/*
	 * Get MIB{^Ńm[hSystem/Interface MIB̎悵 \܂B
	 * 
	 * @param nodeInfo m[hĎ
	 */
	private void getNodeSnmp(NodeInformation nodeInfo) {
		/*
		 * wm[h̃f[^x[XSystem MIBy C^tF[XMIbXV if[^x[XXV݂̂Webւ̉
		 * ͂Ȃj
		 */
		String snmpVersion = nodeInfo.getSnmpVersion();
		int version = 0;

		if (snmpVersion.equals("SNMPV1")) {
			version = SnmpPreference.SNMP_VERSION_1;
		} else if (snmpVersion.equals("SNMPV2C")) {
			version = SnmpPreference.SNMPV2C;
		} else if (snmpVersion.equals("SNMPV3")) {
			version = SnmpPreference.SNMPV3;
		} else {
			logger.warning("Bad snmp version : " + snmpVersion);
		}

		if (!isSocket) {
			SnmpSystemMibGet systemMibGetInstance = null;
			SnmpInterfacesMibGet interfacesMibGetInstance = null;

			try {
				/*
				 * wm[hSystem MIB擾Af[^x[X Ɋi[
				 * 
				 */
				systemMibGetInstance = new SnmpSystemMibGet();
				systemMibGetInstance.setSnmpSystemMibGet(nodeInfo
						.getIpaddress(), version, nodeInfo.getRoCommunity());
				systemMibGetInstance.getSystemMIB();

				/*
				 * wm[hInterfaces MIB擾Af[^ x[XɊi[
				 */
				interfacesMibGetInstance = new SnmpInterfacesMibGet();
				interfacesMibGetInstance.setSnmpInterfacesMibGet(nodeInfo
						.getIpaddress(), version, nodeInfo.getRoCommunity());
				interfacesMibGetInstance.getInterfacesMIB();
				
	            
			} catch (UnknownHostException e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return;
			} catch (SocketException e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return;
			} catch (SnmpMIBGetException e1) {
				logger.warning(e1.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e1.getMessage());
				shell.dispose();

				return;
			}
		}

		SystemMib systemMibInfo = getSystemMib(targetNodeInfo, true);
		setTextNodeInfo(systemMibInfo);

		/*
		 * wm[hInterface MIB擾
		 */
		ArrayList interfaceMibList = getInterfaceMib(targetNodeInfo, true);

		/* Interface MIBXgɂăe[u\ */
		setInterfaceMibTable(interfaceMibList);
	}

	/*
	 * System MIBeLXgɃZbg܂B
	 */
	private void setTextNodeInfo(SystemMib systemMibInfo) {
		/* System MIBeLXg\ */
		if (systemMibInfo != null) {
			/* f[^null̏ꍇɂ̓Zbg */
			if (systemMibInfo.getSysDescr() != null) {
				sysDescrText.setText(systemMibInfo.getSysDescr());
			}

			if (systemMibInfo.getSysUpTime() != null) {
				sysUpTimeText.setText(systemMibInfo.getSysUpTime());
			}

			if (systemMibInfo.getSysName() != null) {
				sysNameText.setText(systemMibInfo.getSysName());
			}

			if (systemMibInfo.getSysContact() != null) {
				sysContactText.setText(systemMibInfo.getSysContact());
			}

			if (systemMibInfo.getSysLocation() != null) {
				sysLocationText.setText(systemMibInfo.getSysLocation());
			}
		}
	}

	/*
	 * w肳ꂽInterface MIB ListInterface MIBe[u \܂B
	 */
	private void setInterfaceMibTable(ArrayList interfaceMibList) {
		if (interfaceMibList == null) {
			return;
		}

		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		/* InterfacePʂɃe[uRowɃZbg */
		InterfaceMib nodeInterfaceMib = null;

		for (int i = 0; i < interfaceMibList.size(); i++) {
			String[] interfaceTableCellArray = new String[7];

			nodeInterfaceMib = (InterfaceMib) interfaceMibList.get(i);
			interfaceTableCellArray[0] = nodeInterfaceMib.getIfIndex();
			interfaceTableCellArray[1] = nodeInterfaceMib.getIfDesc();
			interfaceTableCellArray[2] = nodeInterfaceMib.getIfType();
			interfaceTableCellArray[3] = nodeInterfaceMib.getIfMtu();
			interfaceTableCellArray[4] = nodeInterfaceMib.getIfSpeed();
			interfaceTableCellArray[5] = nodeInterfaceMib.getIfPhysAddress();
			interfaceTableCellArray[6] = nodeInterfaceMib.getIfStatus();

			TableItem item = new TableItem(table, SWT.NULL);
			item.setText(interfaceTableCellArray);
			item.setData(interfaceTableCellArray);

			/*
			 * C^tF[XԂUP̏ꍇ͕BLUEF
			 */
			if (nodeInterfaceMib.getIfStatus().equals(
					DBTableInterfaceMIB.UP_STATUS)) {
				item.setForeground(BLUE_COLOR);
			}
		}
	}

	/*
	 * wm[hSystem MIBf[^x[X擾ĕԂ܂B
	 * 
	 * @return systemMibInfo VXeMIBCX^X
	 */
	private SystemMib getSystemMib(NodeInformation refreshNodeInfo,
			boolean isShowErrorDialog) {
		if (refreshNodeInfo == null) {
			return null;
		}

		SystemMib systemMibInfo = null;

		if (!isSocket) {
			/* System MIBf[^x[X擾 */
			DBTableSystemMIB systemDBtable = DBTableSystemMIB.getInstance();

			try {
				systemMibInfo = systemDBtable
						.findSystemMIBTable(refreshNodeInfo.getIpaddress());
			} catch (DatabaseConnectionException e2) {
				logger.warning(e2.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e2.getMessage());
				shell.dispose();
			} catch (SQLException e2) {
				logger.warning(e2.getMessage());

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e2.getMessage());
				shell.dispose();
			}
		} else {
			/* System MIBT[oSocketɂĎ擾 */
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionSystemMibGet connectSystemMibInfo = new ConnectionSystemMibGet(
					engineAddress);

			try {
				systemMibInfo = connectSystemMibInfo
						.getSystemMib(refreshNodeInfo.getIpaddress());
			} catch (EngineConnectException e) {
				logger.warning("Node System MIB import error" + e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);

					shell.dispose();
				}
			} catch (IOException e) {
				logger.warning("Node System MIB import error" + e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);

					shell.dispose();
				}
			}
		}

		return systemMibInfo;
	}

	/*
	 * Interface MIBIndexɎ擾ăXgɊi[ĕԂ܂B
	 * 
	 * @return Interface MIB񃊃Xg
	 */
	private ArrayList getInterfaceMib(NodeInformation refreshNodeInfo,
			boolean isShowErrorDialog) {
		ArrayList interfaceMibList = null;

		if (!isSocket) {
			/* f[^x[XInterface MIB擾 */
			DBTableInterfaceMIB interfaceMibDBtable = DBTableInterfaceMIB
					.getInstance();

			try {
				interfaceMibList = interfaceMibDBtable.findSNMPInterfaces(
						refreshNodeInfo.getIpaddress(), true);
			} catch (DatabaseConnectionException e2) {
				logger.warning(e2.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e2.getMessage());
					shell.dispose();
				}
			} catch (SQLException e2) {
				logger.warning(e2.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e2.getMessage());
					shell.dispose();
				}
			}
		} else {
			/* T[oSocketɂInterface MIB擾 */
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionInterfaceMib connectInterfaceMib = new ConnectionInterfaceMib(
					engineAddress);

			try {
				interfaceMibList = connectInterfaceMib
						.getInterfaceMib(refreshNodeInfo.getIpaddress());
			} catch (EngineConnectException e) {
				logger.warning("Node Interface MIB import error"
						+ e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);

					shell.dispose();
				}
			} catch (IOException e) {
				logger.warning("Node Interface MIB import error"
						+ e.getMessage());

				if (isShowErrorDialog) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Engine connect error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();
				}
			}
		}

		return interfaceMibList;
	}

	/*
	 * J0iIf Indexj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_IFINDEX_RATIO);
	}

	/*
	 * J1iIf Descj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_IFDESC_RATIO);
	}

	/*
	 * J2iIf Typej̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_IFTYPE_RATIO);
	}

	/*
	 * J3iIf Mtuj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_IFMTU_RATIO);
	}

	/*
	 * J4iIf speedj̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_IFMSPEED_RATIO);
	}

	/*
	 * J5 (If Physaddress) ̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_IFPHYSADDRESS_RATIO);
	}

	/*
	 * J6 (If Status) ̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6_IFSTATUS_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();


		if (table != null) {
			table.dispose();
		}
	}

	/**
	 * e[uColumn\[gNXpA\[g@\ MIBC^tF[X\e[u𐶐NX łB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class SnmpInterfaceMibTable extends AbstractTableView {
		/* e[uColumn click\[gtO */
		private boolean isCol0Direction = true;

		private boolean isCol1Direction = true;

		private boolean isCol2Direction = true;

		private boolean isCol3Direction = true;

		private boolean isCol4Direction = true;

		private boolean isCol5Direction = true;

		private boolean isCol6Direction = true;

		private TableColumn col0;

		private TableColumn col1;

		private TableColumn col2;

		private TableColumn col3;

		private TableColumn col4;

		private TableColumn col5;

		private TableColumn col6;

		/*
		 * Interface MIB\e[u𐶐܂B
		 * 
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			/* e[u */
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			/* Column0(ifIndex) */
			col0 = new TableColumn(table, SWT.CENTER);
			col0.setText(DBTableInterfaceMIB.IF_INDEX);
			col0.setWidth(computeCol0Width());

			/* Column1(ifDesc) */
			col1 = new TableColumn(table, SWT.CENTER);
			col1.setText(DBTableInterfaceMIB.IF_DESC);
			col1.setWidth(computeCol1Width());

			/* Column2(ifType) */
			col2 = new TableColumn(table, SWT.CENTER);
			col2.setText(DBTableInterfaceMIB.IF_TYPE);
			col2.setWidth(computeCol2Width());

			/* Column3(ifMtu) */
			col3 = new TableColumn(table, SWT.CENTER);
			col3.setText(DBTableInterfaceMIB.IF_MTU);
			col3.setWidth(computeCol3Width());

			/* Column4(ifSpeed) */
			col4 = new TableColumn(table, SWT.CENTER);
			col4.setText(DBTableInterfaceMIB.IF_SPEED);
			col4.setWidth(computeCol4Width());

			/* Column5(ifPhysaddress) */
			col5 = new TableColumn(table, SWT.CENTER);
			col5.setText(DBTableInterfaceMIB.IF_PHYSADDRESS);
			col5.setWidth(computeCol5Width());

			/* Column6(ifStatus) */
			col6 = new TableColumn(table, SWT.CENTER);
			col6.setText(DBTableInterfaceMIB.IF_STATUS);
			col6.setWidth(computeCol6Width());

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
							// nothing
						}

						/*
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			col0.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol0Direction = sortIntegerTable(table, 0,
							isCol0Direction);
				}
			});

			col1.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol1Direction = sortTable(table, 1, isCol1Direction);
				}
			});
			col2.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol2Direction = sortTable(table, 2, isCol2Direction);
				}
			});
			col3.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* If Mtu J(l)\[gA\[gێ */
					isCol3Direction = sortIntegerTable(table, 3,
							isCol3Direction);
				}
			});
			col4.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* if Speed J(l)\[gA\[gێ */
					isCol4Direction = sortIntegerTable(table, 4,
							isCol4Direction);
				}
			});
			col5.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol5Direction = sortTable(table, 5, isCol5Direction);
				}
			});
			col6.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol6Direction = sortTable(table, 6, isCol6Direction);
				}
			});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					col0.setWidth(computeCol0Width());
					col1.setWidth(computeCol1Width());
					col2.setWidth(computeCol2Width());
					col3.setWidth(computeCol3Width());

				}
			}
		}

		/**
		 * X[p[NX̃e[uColumn Clickɂ\[g\bh
		 * I[o[ChāAe[uRowForegroundyBackground J[\[gɂĂێ܂B
		 * 
		 * @param table
		 *            Table
		 * @param item
		 *            TableItem
		 * @param strs
		 *            Table item
		 * @return TableItem
		 * @see netjfwatcher.common.view.AbstractTableView#setTableItem
		 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets.
		 *      TableItem, java.lang.String[])
		 */
		protected TableItem setTableItem(Table table, TableItem item,
				String[] strs) {
			Object obj0 = item.getForeground();
			Object obj1 = item.getBackground();

			item.dispose();
			item = new TableItem(table, SWT.NONE);

			item.setText(strs);
			item.setData(strs);

			item.setForeground((Color) obj0);
			item.setBackground((Color) obj1);

			return item;
		}
	}
}
