/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;



/**
 * ASN.1 Type(^O)ɂINTEGER(^Oԍ 0x02)ɑΉSNMPIuWFNg
 * 삷郁\bhNXłB
 *
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpCounter32
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpGauge32
 * @see netjfwatcher.snmp.snmpobject.integer.SnmpCounter64
 */
public class SnmpInteger extends AbstractSnmpObject {
    /** BigIntegerƂIntegerlێ */
    protected BigInteger integerValue;

    /**
     * l0SNMP INTEGERIuWFNg𐶐܂B
    @*/
    public SnmpInteger() {
        this(0); // initialize value to 0

        /*
         * ASN.1 Type(^O)ɂINTEGER(^Oԍ 0x02)Zbg
         */
        tag = SnmpBERCodec.SNMPINTEGER_TAG;
        tagDescription = SnmpBERCodec.SNMPINTEGER;
    }

    /**
     * w̒lSNMP INTEGERIuWFNg𐶐܂B
     *
     * @param newValue JE^[l
     */
    public SnmpInteger(long newValue) {
        this.integerValue = new BigInteger(Long.toString(newValue));

        /*
         * ASN.1 Type(^O)ɂINTEGER(^Oԍ 0x02)Zbg
         */
        tag = SnmpBERCodec.SNMPINTEGER_TAG;
        tagDescription = SnmpBERCodec.SNMPINTEGER;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP INTEGERIuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP INTEGERIuWFNgɎsꍇ
    @*/
    public SnmpInteger(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);

        /*
         * ASN.1 Type(^O)ɂINTEGER(^Oԍ 0x02)Zbg
         */
        tag = SnmpBERCodec.SNMPINTEGER_TAG;
        tagDescription = SnmpBERCodec.SNMPINTEGER;
    }

    /**
     * IntegerlێBigIntegerCX^XԂ܂B
     *
     * @return value IntegerlێBigIntegerCX^X
    @*/
    public Object getValue() {
        return integerValue;
    }

    /**
     * SNMP INTEGERIuWFNgɃf[^Zbg܂B
    *
    * @param newValue ZbgIuWFNgl
    * @throws SnmpBadValueException f[^ZbgɎsꍇ
    @*/
    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            /* ZbglBigInteger */
            integerValue = (BigInteger) newValue;
        } else if (newValue instanceof Integer) {
            /* ZbglInteger */
            integerValue = new BigInteger(((Integer) newValue).toString());
        } else if (newValue instanceof String) {
            /* Zbglx */
            try {
                integerValue = new BigInteger((String) newValue);
            } catch (NumberFormatException e) {
                throw new SnmpBadValueException(
                    " Integer: bad object supplied to set value ");
            }
        } else {
            /* ZbglzȌꍇ */
            throw new SnmpBadValueException(
                " Integer: bad object supplied to set value ");
        }
    }

    /**
     * ێĂIntergerf[^ASN.1 BERGR[fBOɂăoCgz
     * ϊĕԂ܂B
     *
    * @return oCgzf[^
    @*/
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;

        try {
            byte[] data = integerValue.toByteArray();
            byte[] len = this.encodeLength(data.length);

            // encode T,L,V info
            outBytes.write(tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);

            outBytesArray = outBytes.toByteArray();
        } finally {
            try {
                outBytes.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return outBytesArray;
    }

    /**
     * oCgf[^IntegerlƂBigIntegerCX^X𐶐ăZbg
     * ܂B
     *
     * @param enc oCgzf[^
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
    @*/
    public void extractValueFromBEREncoding(byte[] enc)
        throws SnmpBadValueException {
        try {
            integerValue = new BigInteger(enc);
        } catch (NumberFormatException e) {
            throw new SnmpBadValueException(
                " Integer: bad BER encoding supplied to set value ");
        }
    }

    /**
     * ێl𕶎ɕϊĕԂ܂B
     *
     * @return 
     */
    public String toString() {
        return integerValue.toString();
    }
}
