/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂTime Ticks(^Oԍ 0x43)ɑΉ
 * SNMPIuWFNg𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpTimeTicks extends SnmpInteger {
    /**
     * l0SNMP TIMETICKSIuWFNg𐶐܂B
     *
     */
    public SnmpTimeTicks() {
        this(0); // initialize value to 0
    }

    /**
     * longlSNMP TIMETICKSIuWFNg𐶐܂B
     *
     * @param value 10ms(1/100sec)Pʂ̒l
     */
    public SnmpTimeTicks(long value) {
        // 10ms(1/100sec)Pʂ̒lێ
        this.integerValue = new BigInteger(Long.toString(value));
        this.tag = SnmpBERCodec.SNMPTIMETICKS_TAG;
        this.tagDescription = SnmpBERCodec.SNMPTIMETICKS;
    }

    /**
     * ASN.1 BER encodingf[^SNMP TIMETICKSIuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP TIMETICKSIuWFNg̐Ɏsꍇ
     */
    public SnmpTimeTicks(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);
        this.tag = SnmpBERCodec.SNMPTIMETICKS_TAG;
        this.tagDescription = SnmpBERCodec.SNMPTIMETICKS;
    }

    /**
     * TimeTicksli10ms(1/100sec)Pʂ̒lj𕶎ɕϊĕԂ܂B
     *
     * @return timeData TimeTicksli10ms(1/100sec)Pʂ̒lj̕
     */
    public String toString() {
        int ms;
        int second;
        int minute;
        int hour;
        int day;

        /*
         * 10ms(1/100sec)PʂUA1msPʂƂāASecZoł1000Ŋ
         */
        int baseUnit = 1000;
        long time = (super.integerValue).longValue() * 10;

        ms = (int) (time % baseUnit);
        second = (int) ((time / baseUnit) % 60);
        minute = (int) ((time / baseUnit / 60) % 60);
        hour = (int) ((time / baseUnit / 60 / 60) % 24);
        day = (int) (time / baseUnit / 60 / 60 / 24);

        String timeData =
            (super.integerValue).longValue() + " (" + day + "day  " + hour + "hour  "
            + minute + "min  " + second + "sec  " + ms + "msec" + ")";

        return timeData;
    }
}
