/*
 * Created on 2004/09/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.security.Key;


/**
 * USM(User based Security Model)ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class UsmUserEntry {
    /** <p>usmUserAuthProtocol: usmNoAuthProtocol</p> */
    public static final SnmpV3OID USM_NO_AUTH_PROTOCOL =
        new SnmpV3OID("1.3.6.1.6.3.10.1.1.1");

    /** <p>usmUserAuthProtocol: usmHMACMD5AuthProtocol</p> */
    public static final SnmpV3OID USM_HMAC_MD5_AUTH_PROTOCOL =
        new SnmpV3OID("1.3.6.1.6.3.10.1.1.2");

    /** <p>usmUserAuthProtocol: usmHMACSHAAuthProtocol</p> */
    public static final SnmpV3OID USM_HMAC_SHA_AUTH_PROTOCOL =
        new SnmpV3OID("1.3.6.1.6.3.10.1.1.3");

    /** <p>usmUserPrivProtocol: usmNoPrivProtocol</p> */
    public static final SnmpV3OID USM_NO_PRIV_PROTOCOL =
        new SnmpV3OID("1.3.6.1.6.3.10.1.2.1");

    /** <p>usmUserPrivProtocol: usmDESPrivProtocol</p> */
    public static final SnmpV3OID USM_DES_PRIV_PROTOCOL =
        new SnmpV3OID("1.3.6.1.6.3.10.1.2.2");

    /** <p>usmUserStorageType: other(1) -- eh?</p> */
    public static final long OTHER = 1L;

    /** <p>usmUserStorageType: volatile(2) -- e.g., in RAM</p> */
    public static final long VOLATILE = 2L;

    /** <p>usmUserStorageType: nonVolatile(3) -- e.g., in NVRAM</p> */
    public static final long NON_VOLATILE = 3L;

    /** <p>usmUserStorageType: permanent(4) -- e.g., partially in ROM</p> */
    public static final long PERMANENT = 4L;

    /** <p>usmUserStorageType: readOnly(5) -- e.g., completely in ROM</p> */
    public static final long READ_ONLY = 5L;

    /** <p>usmUserStatus: active(1)</p> */
    public static final long ACTIVE = 1L;

    /** <p>usmUserStatus: notInService(2)</p> */
    public static final long NOT_IN_SERVICE = 2L;

    /** <p>usmUserStatus: notReady(3)</p> */
    public static final long NOT_READY = 3L;

    /** <p>usmUserStatus: createAndGo(4)</p> */
    public static final long CREATE_AND_GO = 4L;

    /** <p>usmUserStatus: createAndWait(5)</p> */
    public static final long CREATE_AND_WAIT = 5L;

    /** <p>usmUserStatus: destroy(6)</p> */
    public static final long DESTROY = 6L;
    private SnmpEngineID usmUserEngineID = null;
    private String usmUserName = null;
    private String usmUserSecurityName = null;
    private SnmpV3OID usmUserCloneFrom = null;
    private SnmpV3OID usmUserAuthProtocol = null;
    private String usmUserAuthKeyChange = null;
    private Key usmUserAuthKey = null;
    private String usmUserOwnAuthKeyChange = null;
    private SnmpV3OID usmUserPrivProtocol = null;
    private Key usmUserPrivKey = null;
    private String usmUserPrivKeyChange = null;
    private String usmUserOwnPrivKeyChange = null;
    private String usmUserPublic = null;
    private long usmUserStorageType;
    private long usmUserStatus;

    /**
     * usmUserAuthKeyԂ܂B
     *
     * @return usmUserAuthKey
     */
    public Key getUsmUserAuthKey() {
        return usmUserAuthKey;
    }

    /**
     * usmUserAuthKeyZbg܂B
     *
     * @param usmUserAuthKey usmUserAuthKey
     */
    public void setUsmUserAuthKey(Key usmUserAuthKey) {
        this.usmUserAuthKey = usmUserAuthKey;
    }

    /**
     * usmUserAuthKeyChangeԂ܂B
     *
     * @return usmUserAuthKeyChange
     */
    public String getUsmUserAuthKeyChange() {
        return usmUserAuthKeyChange;
    }

    /**
     * usmUserAuthKeyChangeZbg܂B
     *
     * @param usmUserAuthKeyChange usmUserAuthKeyChange
     */
    public void setUsmUserAuthKeyChange(String usmUserAuthKeyChange) {
        this.usmUserAuthKeyChange = usmUserAuthKeyChange;
    }

    /**
     * usmUserAuthProtocolԂ܂B
     *
     * @return usmUserAuthProtocol
     */
    public SnmpV3OID getUsmUserAuthProtocol() {
        return usmUserAuthProtocol;
    }

    /**
     * usmUserAuthProtocolZbg܂B
     *
     * @param usmUserAuthProtocol usmUserAuthProtocol
     */
    public void setUsmUserAuthProtocol(SnmpV3OID usmUserAuthProtocol) {
        this.usmUserAuthProtocol = usmUserAuthProtocol;
    }

    /**
     * usmUserCloneFromԂ܂B
     *
     * @return usmUserCloneFrom
     */
    public SnmpV3OID getUsmUserCloneFrom() {
        return usmUserCloneFrom;
    }

    /**
     * usmUserCloneFromZbg܂B
     *
     * @param usmUserCloneFrom usmUserCloneFrom
     */
    public void setUsmUserCloneFrom(SnmpV3OID usmUserCloneFrom) {
        this.usmUserCloneFrom = usmUserCloneFrom;
    }

    /**
     * usmUserEngineIDԂ܂B
     *
     * @return usmUserEngineID
     */
    public SnmpEngineID getUsmUserEngineID() {
        return usmUserEngineID;
    }

    /**
     * usmUserEngineIDZbg܂B
     *
     * @param usmUserEngineID usmUserEngineID
     */
    public void setUsmUserEngineID(SnmpEngineID usmUserEngineID) {
        this.usmUserEngineID = usmUserEngineID;
    }

    /**
     * usmUserNameԂ܂B
     *
     * @return usmUserName
     */
    public String getUsmUserName() {
        return usmUserName;
    }

    /**
     * usmUserNameZbg܂B
     *
     * @param usmUserName usmUserName
     */
    public void setUsmUserName(String usmUserName) {
        this.usmUserName = usmUserName;
    }

    /**
     * usmUserOwnAuthKeyChangeԂ܂B
     *
     * @return usmUserOwnAuthKeyChange
     */
    public String getUsmUserOwnAuthKeyChange() {
        return usmUserOwnAuthKeyChange;
    }

    /**
     * usmUserOwnAuthKeyChangeZbg܂B
     *
     * @param usmUserOwnAuthKeyChange usmUserOwnAuthKeyChange
     */
    public void setUsmUserOwnAuthKeyChange(String usmUserOwnAuthKeyChange) {
        this.usmUserOwnAuthKeyChange = usmUserOwnAuthKeyChange;
    }

    /**
     * usmUserOwnPrivKeyChangeԂ܂B
     *
     * @return usmUserOwnPrivKeyChange
     */
    public String getUsmUserOwnPrivKeyChange() {
        return usmUserOwnPrivKeyChange;
    }

    /**
     * usmUserOwnPrivKeyChangeZbg܂B
     *
     * @param usmUserOwnPrivKeyChange usmUserOwnPrivKeyChange
     */
    public void setUsmUserOwnPrivKeyChange(String usmUserOwnPrivKeyChange) {
        this.usmUserOwnPrivKeyChange = usmUserOwnPrivKeyChange;
    }

    /**
     * usmUserPrivKeyԂ܂B
     *
     * @return usmUserPrivKey
     */
    public Key getUsmUserPrivKey() {
        return usmUserPrivKey;
    }

    /**
     * usmUserPrivKeyZbg܂B
     *
     * @param usmUserPrivKey usmUserPrivKey
     */
    public void setUsmUserPrivKey(Key usmUserPrivKey) {
        this.usmUserPrivKey = usmUserPrivKey;
    }

    /**
     * usmUserPrivKeyChangeԂ܂B
     *
     * @return usmUserPrivKeyChange
     */
    public String getUsmUserPrivKeyChange() {
        return usmUserPrivKeyChange;
    }

    /**
     * usmUserPrivKeyChangeZbg܂B
     *
     * @param usmUserPrivKeyChange usmUserPrivKeyChange
     */
    public void setUsmUserPrivKeyChange(String usmUserPrivKeyChange) {
        this.usmUserPrivKeyChange = usmUserPrivKeyChange;
    }

    /**
     * usmUserPrivProtocolԂ܂B
     *
     * @return usmUserPrivProtocol
     */
    public SnmpV3OID getUsmUserPrivProtocol() {
        return usmUserPrivProtocol;
    }

    /**
     * usmUserPrivProtocolZbg܂B
     *
     * @param usmUserPrivProtocol usmUserPrivProtocol
     */
    public void setUsmUserPrivProtocol(SnmpV3OID usmUserPrivProtocol) {
        this.usmUserPrivProtocol = usmUserPrivProtocol;
    }

    /**
     * usmUserPublicԂ܂B
     *
     * @return usmUserPublic
     */
    public String getUsmUserPublic() {
        return usmUserPublic;
    }

    /**
     * usmUserPublicZbg܂B
     *
     * @param usmUserPublic usmUserPublic
     */
    public void setUsmUserPublic(String usmUserPublic) {
        this.usmUserPublic = usmUserPublic;
    }

    /**
     * usmUserSecurityNameԂ܂B
     *
     * @return usmUserSecurityName
     */
    public String getUsmUserSecurityName() {
        return usmUserSecurityName;
    }

    /**
     * usmUserSecurityNameZbg܂B
     *
     * @param usmUserSecurityName usmUserSecurityName
     */
    public void setUsmUserSecurityName(String usmUserSecurityName) {
        this.usmUserSecurityName = usmUserSecurityName;
    }

    /**
     * usmUserStatusԂ܂B
     *
     * @return usmUserStatus
     */
    public long getUsmUserStatus() {
        return usmUserStatus;
    }

    /**
     * usmUserStatusZbg܂B
     *
     * @param usmUserStatus usmUserStatus
     */
    public void setUsmUserStatus(long usmUserStatus) {
        this.usmUserStatus = usmUserStatus;
    }

    /**
     * usmUserStorageTypeԂ܂B
     *
     * @return usmUserStorageType
     */
    public long getUsmUserStorageType() {
        return usmUserStorageType;
    }

    /**
     * usmUserStorageTypeZbg܂B
     *
     * @param usmUserStorageType usmUserStorageType
     */
    public void setUsmUserStorageType(long usmUserStorageType) {
        this.usmUserStorageType = usmUserStorageType;
    }
}
