/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.HashMap;


/**
 * SNMPG[WFgłOIDCX^XHashMapɕێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentThreadInfoMap {
    /* SnmpG[WFgłOIDCX^XOIDL[Ƃĕێ */
    private HashMap agentThreadMap = new HashMap();

    /**
     * SNMPG[WFgłOIDCX^XHashMapɕێ
     * NXCX^X𐶐܂B
     */
    private AgentThreadInfoMap() {
    }

    /**
     * wOIDSnmpG[WFg̃CX^XOID̏Ԃ܂B
     *
     * @param oidKey OID
     * @return CX^XOID
     */
    public AgentThreadInfo getAgentInstanceInfo(final String oidKey) {
        return (AgentThreadInfo) agentThreadMap.get(oidKey);
    }

    /**
     * SNMPG[WFg̃CX^XOID̏HashMapɊi[܂B
     *
     * @param oidKey OID
     * @param agentThreadInfo Agent Thread
     */
    public void setAgentInstanceMap(
        final String oidKey, final Object agentThreadInfo) {
        agentThreadMap.put(oidKey, agentThreadInfo);
    }

    /**
     * SNMPG[WFgłOIDCX^XHashMapɕێ
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static AgentThreadInfoMap getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentThreadInfoMap RESOURCE = new AgentThreadInfoMap();
    }
}
