/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;



/**
 * SNMPG[WFg̃vtFXy[W\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpAgentPreferencePage extends PreferencePage
    implements IWorkbenchPreferencePage {

    /* eLXg */
    private static final int TEXT_WIDTH = 120;

    /* MO */
    private static Logger logger;

    /* ڑzXg */
    private Text allowHostText;

    /* Read Community */
    private Text roCommunityText;

    /* Read/Write Commuity */
    private Text rwCommunityText;

    /**
     * PreferencełB
     *
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /**
     * CompositeContents𐶐܂B
     *
     * @see org.eclipse.jface.preference.
     * PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        /* Snmp\[X擾 */
        SnmpAgentConfigInfo snmpAgentInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        /* }l[WzXg */
        Label label = new Label(composite, SWT.NONE);
        label.setText("Allow-Host");
        label.setLayoutData(new GridData());
        allowHostText = new Text(composite, SWT.BORDER);
        allowHostText.setText(snmpAgentInfo.getAllowHost());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        allowHostText.setLayoutData(gridData);

        /* ReadR~jeB */
        label = new Label(composite, SWT.NONE);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData(gridData);
        roCommunityText = new Text(composite, SWT.BORDER);
        roCommunityText.setText(snmpAgentInfo.getReadCommunity());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        roCommunityText.setLayoutData(gridData);

        /* WriteR~jeB */
        label = new Label(composite, SWT.NONE);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData(gridData);
        rwCommunityText = new Text(composite, SWT.BORDER);
        rwCommunityText.setText(snmpAgentInfo.getWriteCommunity());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        rwCommunityText.setLayoutData(gridData);

        return composite;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        SnmpAgentConfigInfo info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        allowHostText.setText(info.getAllowHost());
        roCommunityText.setText(info.getReadCommunity());
        rwCommunityText.setText(info.getWriteCommunity());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        SnmpAgentConfigInfo info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /* Snmp AgentView text͒lɍXV */
        info.setAllowHost(allowHostText.getText());
        info.setReadCommunity(roCommunityText.getText());
        info.setWriteCommunity(rwCommunityText.getText());

        /* XV񂩂Document񐶐 */
        Document dom =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .updateDocument(info, snmpV3Info);

        // t@Co̓obt@擾
        BufferedWriter bufWriter = null;
        bufWriter =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getResourceFileWriter();

        // XMLt@Co
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                         .outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp V3 agent resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }

        return super.performOk();
    }
}
