/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;
import netjfwatcher.snmpmanager.OidTreeListener;


/**
 * SNMP AgentƂăR}h`钊ۃNXŁASnmp Version
 * ɑΉeNXɌp܂B
 * ȉ̃R}h`܂B
 * EGetRequest
 * EGetNextRequest
 * ESetRequest
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractAgentMessageProcessing {
    /* MO */
    private static Logger logger;

    /**
     * AgentCX^Xf[^OIDL[ƂĕێMap
     */
    protected static HashMap agentOidHashMap =
        AgentMibTree.getInstance().getOidHashMap();

    /** TrapM|[gԍ */
    protected static int trapPort;

    /** \tH[}bg */
    protected static DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    /** SNMPo[W */
    protected int version;

    /** MDatagramPacket */
    protected DatagramPacket inPacket;

    /** MDatagramSocket */
    protected DatagramSocket resSendDatagramSocket;

    /** Trap DatagramSocket */
    protected DatagramSocket trapDatagramSocket;

    /** MSNMP Message */
    protected SnmpMessage receivedMessage;

    /**
     * Snmp AgentƂăR}h`钊ۃNXRXgN^
     * łB
     *
     * @throws SocketException TraoMDatagramSocketɎs
     * ꍇ
     */
    public AbstractAgentMessageProcessing() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());

        /* TrapM|[g */
        trapPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpTrapPort();

        try {
            trapDatagramSocket = new DatagramSocket();
        } catch (SocketException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * SNMPG[WFgƂĂ̎Ms܂B
     *
     * @param inPacket DatagramPacket
     * @param encodedMessage Mf[^oCgz
     * @param receiveLength Mf[^
     *
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws SnmpErrorStatusException }l[Werror statusłȂꍇ
     * @throws SnmpBadValueException f[^͂܂͐ňُ킪ꍇ
     * @throws IOException f[^MɎsꍇ
     */
    abstract void process(
        DatagramPacket inPacket, byte[] encodedMessage, int receiveLength)
        throws GeneralSecurityException, SnmpV3ConfigurationException,
            SnmpErrorStatusException, SnmpBadValueException, IOException;

    /**
     * GetRequestR}hs\bhłB
     *
     * @param snmpVersion SNMPo[W
     * @param community ReadR~jeB
     * @param inPacket f[^MDatagramPacket
     * @param receivedMessage MSNMPbZ[W
     * @throws SnmpErrorStatusException }l[W
     * error statusłȂꍇ
     * @throws SnmpBadValueException f[^͂ňُoꍇ
     * @throws IOException f[^Mňُ킪ꍇ
     */
    protected void getRequest(
        final int snmpVersion, final String community,
        final DatagramPacket inPacket, final SnmpMessage receivedMessage)
        throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        int errorStatus = SnmpPreference.ERROR_STATUS_CORRECT;

        String nextMibOid = null;
        SnmpVarBindList varbindList = new SnmpVarBindList();

        try {
            SnmpSequence varList = null;
            SnmpPDU receivedPDU = receivedMessage.getPDU();

            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException(
                    "OID " + " not available for retrieval");
            }

            varList = receivedPDU.getVarBindList();

            int varListCount = varList.getSequenceContentsList().size();
            SnmpSequence makeVarList = new SnmpSequence();

            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Request ID=" + receivedPDU.getRequestID());

            for (int contentCount = 0; contentCount < varListCount;
                    contentCount++) {
                SnmpSequence newPair =
                    (SnmpSequence) (varList.getSNMPObjectAt(contentCount));

                SnmpObjectIdentifier newObjectIdentifier =
                    (SnmpObjectIdentifier) (newPair.getSNMPObjectAt(0));

                varbindList.addSNMPObject(newPair);

                String retrievedOID = newObjectIdentifier.toString();
                logger.info(
                    "Request ID=" + receivedPDU.getRequestID()
                    + " Request OID=" + retrievedOID);
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Request OID=" + retrievedOID);

                AbstractSnmpObject snmpValue = null;

                if (retrievedOID.equals("1.0")) {
                    retrievedOID = "1.3";
                }

                /*
                 * ManagerOIDɑ΂CX^X
                 */
                if (agentOidHashMap.containsKey(retrievedOID)) {
                    MibInfo miboid =
                        (MibInfo) agentOidHashMap.get(retrievedOID);

                    if ((miboid != null) && (miboid.isAgentInstance())) {
                        snmpValue =
                            ((MibInfo) agentOidHashMap.get(retrievedOID))
                            .getAgentMibValue();

                        /*
                        logger.info(
                            "message snmp value : " + snmpValue.toString());
                        logger.info(
                            "message snmp tag Description : "
                            + snmpValue.getTagDescription());
                            */
                    } else {
                        /*
                         * ManagerOIDAgentƂĂ͕ێĂ邪A
                         * CX^XƂĂ݂͑Ȃ
                         */
                        logger.warning("No such name OID=" + retrievedOID);
                        errorStatus = SnmpPreference.ERROR_STATUS_NOSUCHNAME;
                        snmpValue = new SnmpNull();
                    }
                } else {
                    /* ManagerOID́A݂Ȃ */
                    errorStatus = SnmpPreference.ERROR_STATUS_NOSUCHNAME;
                    logger.warning("No such name OID=" + retrievedOID);

                    if (nextMibOid != null) {
                        retrievedOID = nextMibOid;
                    }

                    snmpValue = new SnmpNull();
                }

                SnmpObjectIdentifier requestedObjectIdentifier =
                    new SnmpObjectIdentifier(retrievedOID);
                SnmpVariablePair nextPair =
                    new SnmpVariablePair(requestedObjectIdentifier, snmpValue);

                makeVarList.addSNMPObject(nextPair);

                /*
                logger.info("Send response retrievedOID : " + retrievedOID);
                logger.info("Send response snmpValue : " + snmpValue);
                logger.info(
                    "Send response snmpValue TagDescription : "
                    + snmpValue.getTagDescription());
                    */
            }

            /*
             * f[^M
             */
            sendResponse(
                snmpVersion, inPacket, receivedPDU.getRequestID(), community,
                makeVarList, errorStatus);

            // parseMessage(receivedMessage);
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * GetNextR}hMɌĂ΂Af[^𐶐M܂B
     *
     * @param snmpVersion SNMPo[W
     * @param community R~jeB
     * @param inPacket DatagramPacket
     * @param receivedMessage SNMPbZ[W
     * @throws SnmpErrorStatusException }l[Werror status
     * łȂꍇ
     * @throws SnmpBadValueException f[^Ɏsꍇ
     * @throws IOException f[^MɎsꍇ
     */
    protected void getNextRequest(
        final int snmpVersion, final String community,
        final DatagramPacket inPacket, final SnmpMessage receivedMessage)
        throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        int errorStatus = 0;

        String nextMibOid = null;
        SnmpVarBindList varbindList = new SnmpVarBindList();

        /*
         * Mf[^vꂽOID𒊏oAYCX^XԂ
         */
        try {
            /* Mf[^PDUo */
            SnmpSequence varList = new SnmpSequence();
            SnmpPDU receivedPDU = receivedMessage.getPDU();

            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException(
                    "OID " + " not available for retrieval");
            }

            /* PDUVarBindListo */
            varList = receivedPDU.getVarBindList();

            int varListCount = varList.getSequenceContentsList().size();
            String retrievedOID = "";
            AbstractSnmpObject snmpValue = null;
            SnmpSequence makeVarList = new SnmpSequence();

            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Request ID=" + receivedPDU.getRequestID());

            for (int contentCount = 0; contentCount < varListCount;
                    contentCount++) {
                SnmpSequence newPair =
                    (SnmpSequence) (varList.getSNMPObjectAt(contentCount));
                SnmpObjectIdentifier newObjectIdentifier =
                    (SnmpObjectIdentifier) (newPair.getSNMPObjectAt(0));

                varbindList.addSNMPObject(newPair);

                errorStatus = 0;

                retrievedOID = newObjectIdentifier.toString();
                logger.info(
                    "Request ID=" + receivedPDU.getRequestID()
                    + " Request OID=" + retrievedOID);
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Request OID=" + retrievedOID);

                if (retrievedOID.equals("1.0")) {
                    retrievedOID = "1.3";
                }

                /*
                 *
                 */
                if (agentOidHashMap.containsKey(retrievedOID)) {
                    /*  */
                    MibInfo mibOid =
                        (MibInfo) agentOidHashMap.get(retrievedOID);
                    MibInfo nextmiboid = null;

                    /*
                     * OID TreeHāACX^Xf[^擾
                     * [vƂāACX^XȂ
                     * ꍇɎOID̂͌OID̊Kw𖞑
                     * 邽߁iȂƂĂOID̊Kw
                     * ̊KwOIDKwɑ݂CX^
                     * XSĂׂł邽߁j
                     */
                    for (;;) {
                        mibOid = (MibInfo) agentOidHashMap.get(retrievedOID);

                        if (mibOid == null) {
                            /* OID`ƂȂꍇ͌I */
                            break;
                        }

                        nextmiboid =
                            (MibInfo) agentOidHashMap.get(
                                mibOid.getNextMibOid());

                        if (nextmiboid == null) {
                            /* OID Tree̍ŌɓB̂Ō[vI */
                            logger.warning(
                                "Next Mib OID null. OID = " + retrievedOID);

                            break;
                        }

                        logger.info("Instance OID = " + retrievedOID);

                        if (nextmiboid.isAgentInstance()) {
                            /*
                             * OIDCX^Xꍇ͌
                             * Iĉɓ
                             */
                            logger.info(
                                "Instance OID = " + retrievedOID + " Access = "
                                + nextmiboid.getAccess());

                            break;
                        }

                        /*
                         * OID̃CX^XȂ̂
                         * OID
                         */
                        retrievedOID = mibOid.getNextMibOid();
                    }

                    /*
                     * OIDCX^X[vɂOIDɑΉ
                     * CX^Xf[^擾ł̃`FbN
                     */
                    if ((mibOid != null) && (nextmiboid != null)) {
                        /* CX^X̒lNext OIDo */
                        nextMibOid = mibOid.getNextMibOid();
                        snmpValue =
                            ((MibInfo) agentOidHashMap.get(nextMibOid))
                            .getAgentMibValue();

                        retrievedOID =
                            ((MibInfo) agentOidHashMap.get(retrievedOID))
                            .getNextMibOid();
                    } else {
                        /*
                         * ẃivꂽjOID̃CX^X݂Ȃ
                         * AOID TreeŎOID`̏ꍇANosuch
                         */
                        logger.warning("Nosuch name OID = " + retrievedOID);
                        errorStatus = SnmpPreference.ERROR_STATUS_NOSUCHNAME;
                        snmpValue = new SnmpNull();
                    }
                } else {
                    /* ẃivꂽjOID`̏ꍇ */
                    logger.warning("Nosuch name OID = " + retrievedOID);
                    errorStatus = SnmpPreference.ERROR_STATUS_NOSUCHNAME;

                    if (nextMibOid != null) {
                        retrievedOID = nextMibOid;
                    }

                    snmpValue = new SnmpNull();
                }

                SnmpObjectIdentifier requestedObjectIdentifier =
                    new SnmpObjectIdentifier(retrievedOID);
                SnmpVariablePair nextPair =
                    new SnmpVariablePair(requestedObjectIdentifier, snmpValue);

                makeVarList.addSNMPObject(nextPair);

                /* logger.info("Send response retrievedOID : " + retrievedOID);
                logger.info("Send response snmpValue : " + snmpValue);
                logger.info(
                    "Send response snmpValue TagDescription : "
                    + snmpValue.getTagDescription());
                    */
            }

            /*
             * f[^M
             */
            sendResponse(
                snmpVersion, inPacket, receivedPDU.getRequestID(), community,
                makeVarList, errorStatus);

            /* logger.info("Send response snmpVersion : " + snmpVersion);
            logger.info(
                "Send response RequestID : " + receivedPDU.getRequestID());
            logger.info("Send response community : " + community);
            logger.info("Send response errorStatus : " + errorStatus);
            */
        } catch (SnmpBadValueException e) {
            logger.warning("Abort GetNextRequest command : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * Snmp}l[WSetRequestR}hMs܂B
     *
     * @param snmpVersion SNMPo[W
     * @param rwCommunity Write R~jeB
     * @param inPacket DatagramPacket
     * @param receivedMessage MbZ[W
     * @throws SnmpErrorStatusException }l[Werror status
     * łȂꍇ
     * @throws SnmpBadValueException Mf[^͂ɎsꍇA
     * ܂͉f[^Ɏsꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public void setRequest(
        final int snmpVersion, final String rwCommunity,
        final DatagramPacket inPacket, final SnmpMessage receivedMessage)
        throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        /*  */
        int errorStatus = 0;

        try {
            SnmpSequence varList = null;

            /* Snmp}l[W̎MPDUo */
            SnmpPDU receivedPDU = receivedMessage.getPDU();

            if (receivedPDU.getErrorStatus() != 0) {
                throw new SnmpErrorStatusException(
                    "Error status not correct : "
                    + receivedPDU.getErrorStatus());
            }

            varList = receivedPDU.getVarBindList();

            SnmpSequence newPair = (SnmpSequence) (varList.getSNMPObjectAt(0));

            SnmpObjectIdentifier receiveOIDInstance =
                (SnmpObjectIdentifier) (newPair.getSNMPObjectAt(0));
            AbstractSnmpObject receiveSNMPObject = newPair.getSNMPObjectAt(1);

            String retrievedOID = receiveOIDInstance.toString();
            logger.info(
                "Request ID=" + receivedPDU.getRequestID() + " Request OID="
                + retrievedOID + ", Value=" + receiveSNMPObject);
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Request ID=" + receivedPDU.getRequestID() + " Request OID="
                + retrievedOID + " Value=" + receiveSNMPObject);

            AbstractSnmpObject snmpObjectValue = null;

            if (agentOidHashMap.containsKey(retrievedOID)) {
                /*
                 * SetvꂽOIDɑΉOidInfo擾
                 * Zbgf[^XV
                 */
                MibInfo agentOidInfo =
                    (MibInfo) agentOidHashMap.get(retrievedOID);

                if (agentOidInfo.isAgentInstance()) {
                    logger.info("instance : " + agentOidInfo.getAccess());
                    logger.info(
                        "Descrip : " + agentOidInfo.getDescrip() + " access : "
                        + agentOidInfo.getAccess());

                    /*
                     * WriteANZX`FbN
                     */
                    if (
                        agentOidInfo.getAccess().equals(
                                OidTreeListener.READ_WRITE_CODE)) {
                        agentOidInfo.setAgentMibValue(receiveSNMPObject);
                        agentOidInfo.setValue(receiveSNMPObject.toString());
                        AgentMibTree.getInstance().getOidHashMap().put(
                            retrievedOID, agentOidInfo);

                        snmpObjectValue = receiveSNMPObject;

                        /*
                         * AgentCX^Xe[u\XV
                         */
                        MibInfo agentInstanceOidInfo =
                            AgentInstanceDataMap.getInstance()
                                                .getAgentInstanceDataInfo(
                                retrievedOID);

                        if (agentInstanceOidInfo != null) {
                            agentInstanceOidInfo.setAgentMibValue(
                                receiveSNMPObject);
                            agentInstanceOidInfo.setValue(
                                receiveSNMPObject.toString());
                            AgentInstanceDataMap.getInstance()
                                                .setAgentInstanceDataMap(
                                retrievedOID, agentInstanceOidInfo);
                            AgentInstanceDataRefreshQueue.getInstance()
                                                         .pushQueue(
                                agentInstanceOidInfo);
                        } else {
                            logger.warning("No Access : " + retrievedOID);
                            errorStatus = SnmpPreference.ERROR_STATUS_NOACCESS;
                            snmpObjectValue = new SnmpNull();
                        }
                    } else {
                        logger.warning("Not writable : " + retrievedOID);
                        errorStatus = SnmpPreference.ERROR_STATUS_NO_WRITABLE;
                        snmpObjectValue = new SnmpNull();
                    }
                } else {
                    logger.warning("No Access : " + retrievedOID);
                    errorStatus = SnmpPreference.ERROR_STATUS_NOACCESS;
                    snmpObjectValue = new SnmpNull();
                }
            } else {
                logger.warning("Nosuch name : : " + retrievedOID);
                errorStatus = SnmpPreference.ERROR_STATUS_NOSUCHNAME;
                snmpObjectValue = new SnmpNull();
            }

            /*
             * Managerɉ𑗐M
             */
            sendResponse(
                snmpVersion, inPacket, receivedPDU.getRequestID(), retrievedOID,
                rwCommunity, snmpObjectValue, errorStatus);
        } catch (SnmpBadValueException e) {
            logger.warning("Abort SetRequest command : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * w肳ꂽOIDyђlɂ艞f[^쐬āA}l[W
     * f[^𑗐M郁\bhłB
     *
     * @param snmpVersion SNMPo[W
     * @param inPacket DatagramPacket
     * @param requestID ʎq
     * @param oid OID
     * @param community R~jeB
     * @param snmpValueObject SNMP Object
     * @param errorStatus G[Xe[^X
     * @throws SnmpBadValueException f[^Ɏsꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public void sendResponse(
        final int snmpVersion, final DatagramPacket inPacket,
        final int requestID, final String oid, final String community,
        final AbstractSnmpObject snmpValueObject, final int errorStatus)
        throws SnmpBadValueException, IOException {
        /* bZ[W쐬 */
        byte[] messageEncoding =
            makeMessage(
                snmpVersion, requestID, oid, community, snmpValueObject,
                errorStatus);

        /* f[^Mpf[^O */
        DatagramPacket outPacket =
            new DatagramPacket(
                messageEncoding, messageEncoding.length, inPacket.getAddress(),
                inPacket.getPort());

        try {
            /* f[^M */
            resSendDatagramSocket.send(outPacket);
            logger.info(
                hexBytetoString(messageEncoding, outPacket.getLength()));

            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Response send date : " + dateformat.format(date)
                + " : Data length : " + messageEncoding.length + "Byte");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                hexBytetoString(messageEncoding, messageEncoding.length) + "\n");
        } catch (IOException e) {
            logger.warning("Response send : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * w肳ꂽOIDyђlɂ艞f[^쐬āA}l[W
     * f[^𑗐M郁\bhłB
     *
     * @param snmpVersion SNMPo[W
     * @param inPacket DatagramPacket
     * @param requestID ʎq
     * @param community R~jeB
     * @param varList SNMP varList
     * @param errorStatus G[Xe[^X
     * @throws SnmpBadValueException f[^Ɏsꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public void sendResponse(
        final int snmpVersion, final DatagramPacket inPacket,
        final int requestID, final String community, final SnmpSequence varList,
        final int errorStatus) throws SnmpBadValueException, IOException {
        /* bZ[W쐬 */
        byte[] messageEncoding =
            makeMessage(
                snmpVersion, requestID, community, varList, errorStatus);

        /* f[^Mpf[^O */
        DatagramPacket outPacket =
            new DatagramPacket(
                messageEncoding, messageEncoding.length, inPacket.getAddress(),
                inPacket.getPort());

        try {
            /* f[^M */
            resSendDatagramSocket.send(outPacket);
            logger.info(
                hexBytetoString(messageEncoding, outPacket.getLength()));

            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Response send date : " + dateformat.format(date)
                + " : Data length : " + messageEncoding.length + "Byte");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                hexBytetoString(messageEncoding, messageEncoding.length) + "\n");
        } catch (IOException e) {
            logger.warning("Response send : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * SNMPG[WFgƂāA}l[W̃R}hMɑ΂
     * bZ[W𐶐ĕԂ܂B
     *
     * @param snmVesion SNMPo[W
     * @param requestID ʎq
     * @param oid OID
     * @param community R~jeB
     * @param snmpobject SNMP Obejct
     * @param errorStatus G[Xe[^X
     * @return messageEncodin bZ[WoCgz
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     */
    public byte[] makeMessage(
        int snmVesion, int requestID, String oid, String community,
        AbstractSnmpObject snmpobject, int errorStatus)
        throws SnmpBadValueException {
        /*  */
        int errorIndex = 0;

        byte[] messageEncoding = null;

        try {
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(oid);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, snmpobject);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            /* PDU */
            SnmpPDU pdu =
                new SnmpPDU(
                    SnmpBERCodec.SNMPGETRESPONSE, requestID, errorStatus,
                    errorIndex, varList);

            /* Message */
            SnmpMessage message = new SnmpMessage(snmVesion, community, pdu);
            messageEncoding = message.getBEREncoding();
        } catch (SnmpBadValueException e) {
            logger.warning("Create response message : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return messageEncoding;
    }

    /**
     * SNMPG[WFgƂāA}l[W̃R}hMɑ΂
     * bZ[W𐶐ĕԂ܂B
     *
     * @param snmVesion SNMPo[W
     * @param requestID ʎq
     * @param community R~jeB
     * @param varList SNMP VarList
     * @param errorStatus G[Xe[^X
     * @return messageEncodin bZ[WoCgz
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     */
    public byte[] makeMessage(
        int snmVesion, int requestID, String community, SnmpSequence varList,
        int errorStatus) throws SnmpBadValueException {
        int errorIndex = 0;
        byte[] messageEncoding = null;

        try {
            /* PDU */
            SnmpPDU pdu =
                new SnmpPDU(
                    SnmpBERCodec.SNMPGETRESPONSE, requestID, errorStatus,
                    errorIndex, varList);

            /* Message */
            SnmpMessage message = new SnmpMessage(snmVesion, community, pdu);
            messageEncoding = message.getBEREncoding();
        } catch (SnmpBadValueException e) {
            logger.warning("Create response message : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return messageEncoding;
    }

    /**
      * wPDUŃbZ[W𐶐A}l[WTrap𑗐M܂B
      *
      * @param hostAddress MAhX
      * @param community R~jeB
      * @param pdu PDU
      * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
      * @throws UnknownHostException MAhXs̏ꍇ
      * @throws SnmpV3ConfigurationException SNMP V3\񂪈ُȏꍇ
      * @throws SnmpBadValueException MTrapbZ[W̐Ɏsꍇ
      * @throws IOException Trap̑MɎsꍇ
      */
    public abstract void sendTrap(
        final String hostAddress, final String community, final SnmpSequence pdu)
        throws GeneralSecurityException, UnknownHostException, 
            SnmpV3ConfigurationException, SnmpBadValueException, IOException;

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();

        if (trapDatagramSocket != null) {
            trapDatagramSocket.close();
        }
    }

    /**
     * MoCgf[^\p̕ɕϊ܂B
     *
     * @param byteData ϊoCgf[^
     * @param receiveLength Mf[^
     * @return ϊ
     */
    public String hexBytetoString(byte[] byteData, int receiveLength) {
        StringBuffer returnString = new StringBuffer();

        for (int i = 0; (byteData.length > i) && (receiveLength > i); i++) {
            if (i != 0) {
                if ((i % 16) == 0) {
                    returnString.append(System.getProperty("line.separator"));
                }
            }

            int pos = byteData[i];

            if (pos < 0) {
                pos += 256;
            }

            returnString.append(Integer.toHexString(pos / 16));
            returnString.append((Integer.toHexString(pos % 16) + " "));
        }

        return returnString.toString();
    }

    /**
     * oCgf[^𕶎ɕϊĕԂ܂B
     *
     * @param byteData ɕϊoCgR[h
     * @return ϊ
     */
    public String hexByte(byte byteData) {
        String returnString = "";

        int pos = byteData;

        if (pos < 0) {
            pos += 256;
        }

        returnString += Integer.toHexString(pos / 16);
        returnString += Integer.toHexString(pos % 16);

        return returnString;
    }

    public String bytetoString(byte[] b) {
        String returnString = "";

        for (int i = 0; i < b.length; i++) {
            returnString += Byte.toString(b[i]);
        }

        return returnString;
    }

    public String bytetoChar(byte[] b) {
        String returnString = "";

        for (int i = 0; i < b.length; i++) {
            returnString += (char) b[i];
        }

        return returnString;
    }
}
