/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;



/**
 * MIB(OID) TreȇIXi[NXłB
 * IꂽOID𑼂̑r[ɃZbg郁\bh
 * ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class OidTreeListener implements SelectionListener {
    /** MIB Access Type Read Only Code */
    public static final String READ_ONLY_CODE = "ro";

    /** MIB Access Type Read/Write Code */
    public static final String READ_WRITE_CODE = "rw";

    /** MIB Access Type Not-Accessible Code */
    public static final String NOT_ACCESSIBLE_CODE = "n";

    /** MIB Access Type Read Only Description */
    public static final String READ_ONLY_DESCRIPTION = "read-only";

    /** MIB Access Type Read/Write Only Description */
    public static final String READ_WRITE_DESCRIPTION = "read-write";

    /** MIB Access Type Not-accessible Description */
    public static final String NOT_ACCESSIBLE_DESCRIPTION = "not-accessible";

    /*
     * OID TreȇIXi[NXCX^X𐶐܂B
     *
     */
    private OidTreeListener() {
    }

    /**
     * OID TreeI擾đ̃r[ɃZbg܂B
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        /* OID TreeőIꂽOID擾 */
        TreeItem item = (TreeItem) event.item;

        if (item == null) {
            return;
        }

        MibInfo oidInfo = (MibInfo) item.getData();
        updateManagerOperationView(oidInfo);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.swt.events.
     * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent event) {
    }

    /*
     * SNMP V1/V2/V3uEUr[OIDZbg܂B
     *
     * @param oidInfo OID
     */
    private void updateManagerOperationView(final MibInfo oidInfo) {
        /*
         * OID TreeőIꂽOIDsnmp V1/V2C/V3 Manager View
         * OID̓eLXgɃZbg
         */
        NetJFWatcherApplication.getSnmpV1OperationView().getOidText().setText(
            oidInfo.getOid());
        NetJFWatcherApplication.getSnmpV2OperationView().getOidText().setText(
            oidInfo.getOid());
        NetJFWatcherApplication.getSnmpV3OperationView().getOidText().setText(
            oidInfo.getOid());

        String valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;

        String oidType = oidInfo.getSyntax();

        if (oidType.equals(ManagerMibTree.INTEGER)) {
            valueTypeString = SnmpBERCodec.SNMPINTEGER;
        } else if (oidType.equals(ManagerMibTree.COUNTER32)) {
            valueTypeString = SnmpBERCodec.SNMPCOUNTER32;
        } else if (oidType.equals(ManagerMibTree.COUNTER64)) {
            valueTypeString = SnmpBERCodec.SNMPCOUNTER64;
        } else if (oidType.equals(ManagerMibTree.GAUGE32)) {
            valueTypeString = SnmpBERCodec.SNMPGAUGE32;
        } else if (oidType.equals(ManagerMibTree.OCTETSTRING)) {
            valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;
        } else if (oidType.equals(ManagerMibTree.IPADDRESS)) {
            valueTypeString = SnmpBERCodec.SNMPIPADDRESS;
        } else if (oidType.equals(ManagerMibTree.OBJECTID)) {
            valueTypeString = SnmpBERCodec.SNMPOBJECTIDENTIFIER;
        } else if (oidType.equals(ManagerMibTree.TIMETICKS)) {
            valueTypeString = SnmpBERCodec.SNMPTIMETICKS;
        } else if (oidType.equals(ManagerMibTree.UINTEGER32)) {
            valueTypeString = SnmpBERCodec.SNMPUINTEGER32;
        } else if (oidType.equals(ManagerMibTree.BITS)) {
            valueTypeString = SnmpBERCodec.SNMPBITSTRING;
        } else if (oidType.equals(ManagerMibTree.OPAQUE)) {
            valueTypeString = SnmpBERCodec.SNMPOPAQUE;
        } else if (oidType.equals(ManagerMibTree.DISPLAYSTRING)) {
            valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;
        } else {
            // logger.warning("Error type" + miboid.getSyntax());
        }

        NetJFWatcherApplication.getSnmpV1OperationView().getSetValueText().setText("");
        NetJFWatcherApplication.getSnmpV2OperationView().getSetValueText().setText("");
        NetJFWatcherApplication.getSnmpV3OperationView().getSetValueText().setText("");

        /*
         * OID TreeőIꂽOIDTypesnmp manager
         * viewłTypeIComboBoxɃZbg
         */
        NetJFWatcherApplication.getSnmpV1OperationView().getSnmpValueTypeCombo()
                       .setText(valueTypeString);
        NetJFWatcherApplication.getSnmpV2OperationView().getSnmpValueTypeCombo()
                       .setText(valueTypeString);
        NetJFWatcherApplication.getSnmpV3OperationView().getSnmpValueTypeCombo()
                       .setText(valueTypeString);

        if (oidInfo.getAccess().equals(READ_ONLY_CODE)) {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText()
                           .setText(READ_ONLY_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText()
                           .setText(READ_ONLY_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText()
                           .setText(READ_ONLY_DESCRIPTION);
        } else if (oidInfo.getAccess().equals(READ_WRITE_CODE)) {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText()
                           .setText(READ_WRITE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText()
                           .setText(READ_WRITE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText()
                           .setText(READ_WRITE_DESCRIPTION);
        } else {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText()
                           .setText(NOT_ACCESSIBLE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText()
                           .setText(NOT_ACCESSIBLE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText()
                           .setText(NOT_ACCESSIBLE_DESCRIPTION);
        }

        /*
         *
         */
        SnmpV1ValueTypeSelection.getInstance().setSnmpValueType(
            valueTypeString);
        SnmpV2ValueTypeSelection.getInstance().setSnmpValueType(
            valueTypeString);
        SnmpV3ValueTypeSelection.getInstance().setSnmpValueType(
            valueTypeString);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static OidTreeListener getInstance() {
        return SingletonResource.LISTENER;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final OidTreeListener LISTENER = new OidTreeListener();
    }
}
