/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


/**
 * SNMP V2}l[Wł̃Iy[VViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 *
 */
public class SnmpV2OperationView extends AbstractSnmpOperationView {
    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        /* Xe[^XC\Zbg */
        setStatusLine();

        /*  */
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

        dataHolder = new SnmpOperationDataHolder();
        dataHolder.setSnmpVersion(SnmpPreference.SNMPV2C);

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.NULL);

        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        GridData gridData = null;

        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Agent Address");
        label.setLayoutData(new GridData());
        targetIPText = new Text(composite, SWT.BORDER);
        targetIPText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        targetIPText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Request OID");
        label.setLayoutData(new GridData());
        oidText = new Text(composite, SWT.BORDER);
        oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        oidText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Set Value");
        gridData = new GridData();
        label.setLayoutData(gridData);

        setValueText = new Text(composite, SWT.BORDER);
        setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = SET_VALUE_TEXT_WIDTH;
        setValueText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Access Type");
        gridData = new GridData();
        label.setLayoutData(gridData);

        accessTypeText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        accessTypeText.setEnabled(false);
        accessTypeText.setBackground(textBackColor);
        setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        accessTypeText.setLayoutData(gridData);

        /* SNMP Type */
        label = new Label(composite, SWT.NONE);
        label.setText("Value Type");
        gridData = new GridData();
        label.setLayoutData(gridData);

        snmpValueTypeCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPINTEGER);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER64);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPGAUGE32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOCTETSTRING);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPIPADDRESS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPNSAPADDRESS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOBJECTIDENTIFIER);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPTIMETICKS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPUINTEGER32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPBITSTRING);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOPAQUE);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        snmpValueTypeCombo.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(6, false);
        Composite composite2 = new Composite(baseComposite, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        label = new Label(composite2, SWT.NONE);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        roCommunityText = new Text(composite2, SWT.BORDER);
        roCommunityText.setText(READ_COMMUNITY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        roCommunityText.setLayoutData(gridData);

        getNextButton = new Button(composite2, SWT.NONE);
        getNextButton.setText(GETNEXTREQUEST_BUTTON);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        getNextButton.setLayoutData(gridData);

        label = new Label(composite2, SWT.NONE);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        rwCommunityText = new Text(composite2, SWT.BORDER);
        rwCommunityText.setText(READ_WRITE_COMMUNITY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        rwCommunityText.setLayoutData(gridData);

        snmpSetButton = new Button(composite2, SWT.NONE);
        snmpSetButton.setText("Set");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        snmpSetButton.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite2, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        getRequestButton = new Button(composite2, SWT.NONE);
        getRequestButton.setText(GETREQUEST_BUTTON);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        getRequestButton.setLayoutData(gridData);

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        setInitText();

        /*
         * GetNext Request{^Xi[Zbg
         */
        getRequestButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * GetRequestłB
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    getRequestButtonListener();
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * Get Next Request{^Xi[
         *
         */
        getNextButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    getNextRequestButtonListener();
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * SNMPIuWFNgTypeIXi[
         */
        snmpValueTypeCombo.addSelectionListener(
            SnmpV2ValueTypeSelection.getInstance());

        /*
         * Set Request{^Xi[
         */
        snmpSetButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    setRequestButtonListener();
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        int snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
        String snmpV2Timeout =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV2Timeout();
        String snmpV2Retry =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV2Retry();
        statusLineManager.setMessage(
            "Snmp Port=" + snmpPort + " timeout=" + snmpV2Timeout + " retry="
            + snmpV2Retry);
    }
}
