/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmpmanager.TableDataCsvFileOutput;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;



/**
 * Snmp}l[W(MIB Browser)ɂ̎MIBCX^Xf[^\
 * e[ũANV\z܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 *
 */
public class ActionBuilderOidTable {
    /* MO */
    private static Logger logger;

    /* ̎CX^Xf[^\e[u */
    private final Table instanceTable;

    /* ̎CX^Xf[^\e[uClearANV */
    private final IAction clearTableAction = new ActionTableClear();

    /* ̎CX^Xf[^ ExportANV */
    private final IAction exportOidInstanceInfoAction =
        new ActionExportOidInstanceInfo();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * Snmp}l[W̎MIBCX^Xf[^\e[ũANV
     * NXCX^X𐶐܂B
     *
     * @param table Table
     */
    public ActionBuilderOidTable(Table table) {
        this.instanceTable = table;
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * OIDe[uNAANVԂ܂B
     *
     * @return clearTableAction NAANV
     */
    public IAction actionClearTable() {
        return clearTableAction;
    }

    /**
     * OIDe[u(G[WFg̎f[^)GNX|[g
     * ANVԂ܂B
     *
     * @return exportOidInstanceInfoAction GNX|[gANV
     */
    public IAction actionExportOidInstanceInfo() {
        return exportOidInstanceInfoAction;
    }

    /**
     * OIDe[u(G[WFg̎f[^)ANV`
     * ۃNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeAction extends Action {
        /*
             *  (non-Javadoc)
             * @see org.eclipse.jface.action.IAction#run()
             */
        public final void run() {
            doTask();
        }

        /**
         * ANVŎׂ\bhŃANVŌĂ΂܂B
         *
         */
        protected abstract void doTask();
    }

    /**
     * TableNAsANVNXłB
     */
    private final class ActionTableClear extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/clear.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "TableNA";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "TableNA܂";
        }

        /**
         * TableNA܂B
         *
         */
        protected void doTask() {
            /* e[ȗSč폜ătbV */
            instanceTable.removeAll();

            TableViewer view = NetJFWatcherApplication.getOidTableView().getViewer();
            view.refresh();
        }
    }

    /**
     * OIDe[u(G[WFg̎f[^)GNX|[gANVNXłB
     */
    private final class ActionExportOidInstanceInfo extends AbstractNodeAction {
        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/saveas_edit.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "e[ȕt@Co";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "e[ȕt@Co͂܂";
        }

        /*
         *  ( Javadoc)
         * @see rctf.rssr.snmpmanager.
         * OidTableActionBuilder.AbstractNodeAction#doTask()
         */
        protected void doTask() {
            // String csvFile = null;

            /* o͂CSVt@CI */
            /* FileChooser fileChooser = new FileChooser();
            csvFile =
                fileChooser.getChooserFile(
                    FileChooser.CSVFILE_OUTPUT,
                    FileChooser.FILE_CHOOSER[FileChooser.CSV_FILE]);

            if (csvFile == null) {
                return;
            } */
            Shell shell = new Shell();

            try {
                /* GNX|[gt@CI_CAO */
                FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
                String csvFile = openDialog.open();

                logger.info("CSV file name : " + csvFile);

                if (csvFile == null) {
                    return;
                }

                TableDataCsvFileOutput fileOutput = TableDataCsvFileOutput.getInstance();
                fileOutput.writeCSVFile(csvFile, instanceTable);
            } catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
                MessageDialog.openError(
                    shell, "Error", "FileNotFoundException " + e.getMessage());

                return;
            } catch (IOException e) {
                logger.warning(e.getMessage());
                MessageDialog.openError(
                    shell, "Error", "IOException " + e.getMessage());

                return;
            } finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
        }
    }
}
