/*
 * Created on 2007/01/30
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.snmpmanager.trap.EnterpriseOIDConfig;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;
import netjfwatcher.snmpmanager.trap.TrapForwardResourceFileParse;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class SnmpTrapForwardPreferencePage extends AbstractSnmpPreferencePage {

	private static final int TEXT_WIDTH = 200;

	private static final int AGENT_LIST_VERTICAL_SPAN = 11;

	private static final int AGENT_LIST_HEIGHT_HINT = 5;

	private static final int WIDE_TEXT_WIDTH = 250;

	private static final int COMBO_VISIBLE_ITEM_COUNT = 15;

	private static final int HORIZONTAL_SPAN2 = 2;

	private static final int HORIZONTAL_SPAN3 = 3;

	private static final int LIS_WIDTH = 200;

	private Button trapForwardButton;

	private Text destinationAddressText;

	private List enterprisesOIDList = null;

	private Combo enterpriseOidCombo;

	private Text removeOIDText;

	/* Agentǉ{^ */
	private Button addOIDButton;

	/* Agent폜{^ */
	private Button removeOIDButton;

	private Map enterpriseOidInfoMap;

	private ArrayList<String> workEnterpriseOidList;

	private HashMap<String, EnterpriseOIDInfo> filetrEnterpriseOidMap;

	/* MO */
	private static Logger logger;


	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());
		workEnterpriseOidList = new ArrayList<String>();
		filetrEnterpriseOidMap = new HashMap<String, EnterpriseOIDInfo>();

		enterpriseOidInfoMap = EnterpriseOIDConfig.getInstance()
				.getEnterpriseOidHashMap();
	}

	/**
	 * Rec𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 * @return Control
	 */
	protected Control createContents(Composite parent) {
		/* TextwiFZbg */
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		/*
		 * Snmp V3 AgentAhXXgAgentAhXɑΉ vpeB\
		 */
		Composite compositeEnterpriseOid = new Composite(parent, SWT.NONE);

		/* ep[c3Ŕzu */
		GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
		compositeEnterpriseOid.setLayout(gridLayoutV3AgentProp);
		compositeEnterpriseOid.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));

		trapForwardButton = new Button(compositeEnterpriseOid, SWT.CHECK);
		trapForwardButton.setText("Trap Forward");

		Label label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("Destination Address");
		label.setLayoutData(new GridData());
		destinationAddressText = new Text(compositeEnterpriseOid, SWT.BORDER);
		destinationAddressText.setText("");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		destinationAddressText.setBackground(textBackColor);
		destinationAddressText.setLayoutData(gridData);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("Effective Enterprises OID");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		enterprisesOIDList = new List(compositeEnterpriseOid, SWT.SINGLE
				| SWT.BORDER);

		GridData data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN2;
		data.verticalSpan = AGENT_LIST_VERTICAL_SPAN; // XgXpZbg
		data.widthHint = LIS_WIDTH;
		data.heightHint = enterprisesOIDList.getItemHeight()
				* AGENT_LIST_HEIGHT_HINT;
		enterprisesOIDList.setLayoutData(data);

		label = new Label(compositeEnterpriseOid, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = AGENT_LIST_VERTICAL_SPAN - 1;
		label.setLayoutData(gridData);

		enterpriseOidCombo = new Combo(compositeEnterpriseOid, SWT.DROP_DOWN);

		Iterator it;
		for (it = enterpriseOidInfoMap.keySet().iterator(); it.hasNext();) {
			String keyOid = (String) it.next();
			EnterpriseOIDInfo info = (EnterpriseOIDInfo) enterpriseOidInfoMap
					.get(keyOid);
			enterpriseOidCombo.add(keyOid + "     (" + info.getCompany() + ")");
			workEnterpriseOidList.add(keyOid);

		}

		enterpriseOidCombo.select(0);

		gridData = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDE_TEXT_WIDTH;
		enterpriseOidCombo.setLayoutData(gridData);
		enterpriseOidCombo.setVisibleItemCount(COMBO_VISIBLE_ITEM_COUNT);

		addOIDButton = new Button(compositeEnterpriseOid, SWT.NULL);
		addOIDButton.setText("Add Effective Enterprises OID");
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		addOIDButton.setLayoutData(gridData);

		removeOIDText = new Text(compositeEnterpriseOid, SWT.BORDER);
		removeOIDText.setText("");
		gridData = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDE_TEXT_WIDTH;
		removeOIDText.setLayoutData(gridData);

		removeOIDButton = new Button(compositeEnterpriseOid, SWT.NULL);
		removeOIDButton.setText("Remove Effective Enterprises OID");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		removeOIDButton.setLayoutData(gridData);

		Composite entryTable = new Composite(parent, SWT.NULL);
		entryTable.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		setSelectionListener();

		setText();

		return entryTable;
	}

	private void setText() {
		String forwardFlag = TrapForwardResourceFileParse.getInstance()
				.getForwardFlag();
		if (forwardFlag.equals("true")) {
			trapForwardButton.setSelection(true);
		} else {
			trapForwardButton.setSelection(false);
		}
		String forwardAddress = TrapForwardResourceFileParse.getInstance()
				.getForwardAddress();
		destinationAddressText.setText(forwardAddress);

		enterprisesOIDList.removeAll();
		filetrEnterpriseOidMap.clear();
		ArrayList enterpriseOidList = TrapForwardResourceFileParse
				.getInstance().getEnterpriseOidList();
		for (int i = 0; i < enterpriseOidList.size(); i++) {
			String oid = (String) enterpriseOidList.get(i);

			if (!filetrEnterpriseOidMap.containsKey(oid)) {
				enterprisesOIDList.add(oid);
				EnterpriseOIDInfo info = (EnterpriseOIDInfo) enterpriseOidInfoMap
						.get(oid);
				filetrEnterpriseOidMap.put(oid, info);
			}

		}
		if (trapForwardButton.getSelection()) {
			destinationAddressText.setEnabled(true);
			enterprisesOIDList.setEnabled(true);
			addOIDButton.setEnabled(true);
			removeOIDButton.setEnabled(true);
		} else {
			destinationAddressText.setEnabled(false);
			enterprisesOIDList.setEnabled(false);
			addOIDButton.setEnabled(false);
			removeOIDButton.setEnabled(false);
		}

	}

	private void setSelectionListener() {
		addOIDButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				int index = enterpriseOidCombo.getSelectionIndex();
				String selectEnterpriseOid = workEnterpriseOidList.get(index);

				if (!filetrEnterpriseOidMap.containsKey(selectEnterpriseOid)) {
					enterprisesOIDList.add(selectEnterpriseOid);
					EnterpriseOIDInfo info = (EnterpriseOIDInfo) enterpriseOidInfoMap
							.get(selectEnterpriseOid);
					filetrEnterpriseOidMap.put(selectEnterpriseOid, info);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		removeOIDButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (removeOIDText.getText().equals("")) {
					return;
				}
				if (filetrEnterpriseOidMap.containsKey(removeOIDText.getText())) {
					enterprisesOIDList.remove(removeOIDText.getText());
					filetrEnterpriseOidMap.remove(removeOIDText.getText());
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		enterprisesOIDList.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				int index = enterprisesOIDList.getSelectionIndex();
				if (index < 0) {
					return;
				}
				String selectEnterpriseOid = enterprisesOIDList.getItem(index);

				removeOIDText.setText(selectEnterpriseOid);

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		trapForwardButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (trapForwardButton.getSelection()) {
					destinationAddressText.setEnabled(true);
					enterprisesOIDList.setEnabled(true);
					addOIDButton.setEnabled(true);
					removeOIDButton.setEnabled(true);
				} else {
					destinationAddressText.setEnabled(false);
					enterprisesOIDList.setEnabled(false);
					addOIDButton.setEnabled(false);
					removeOIDButton.setEnabled(false);
				}

			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	protected void performDefaults() {
		setText();
	}

	public boolean performOk() {

		ArrayList<String> setOidList = new ArrayList<String>();
		Iterator it = null;
		for (it = filetrEnterpriseOidMap.keySet().iterator(); it.hasNext();) {
			String ednterpriseOIDdKey = (String) it.next();
			setOidList.add(ednterpriseOIDdKey);

		}
		String forwardFlag = "true";
		if (!trapForwardButton.getSelection()) {
			forwardFlag = "false";
		}
		String forwardAddress = "";

		if (forwardFlag.equals("true")) {
			forwardAddress = destinationAddressText.getText();
			String localHostAddress = "";
			try {
				InetAddress host = InetAddress.getByName(forwardAddress);
				forwardAddress = host.getHostAddress();
				localHostAddress = InetAddress.getLocalHost().getHostAddress();
			} catch (UnknownHostException e2) {
				MessageDialog.openError(getShell(), "Error",
						"UnknownHostException" + " IP Address = "
								+ forwardAddress);
				destinationAddressText.setFocus();

				return false;
			}

			if ((forwardAddress == null) || forwardAddress.equals("")
					|| forwardAddress.equals("127.0.0.1")
					|| forwardAddress.equals(localHostAddress)) {
				MessageDialog.openError(getShell().getShell(), "Error",
						"Illegal IP Address");
				destinationAddressText.setFocus();

				return false;
			}
		}
		saveTrapForwardInfo(forwardFlag, forwardAddress, setOidList);
		return super.performOk();
	}

	private void saveTrapForwardInfo(String forwardFlag, String forwardAddress,
			ArrayList oidList) {
		// Document
		Document dom = null;

		// t@Co̓obt@
		BufferedWriter bufWriter = null;
		dom = this.updateTrapForwardResource(forwardFlag, forwardAddress,
				oidList);

		if (dom == null) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error",
					"Abort save Trap forward config");
			shell.dispose();

			return;
		}

		bufWriter = TrapForwardResourceFileParse.getInstance()
				.getResourceFileWriter();

		// XMLt@Co
		this.outputXMLFile(bufWriter, dom);

		if (bufWriter != null) {
			try {
				bufWriter.close();
			} catch (IOException e) {
				logger
						.warning("Abort close BufferedWriter for Trap forward resource : "
								+ e.getMessage());
				e.printStackTrace();
			}
		}

		// FileɃCgɃCX^XXV
		TrapForwardResourceFileParse.getInstance().setTrapForwardInfo();
	}

	private Document updateTrapForwardResource(String forwardFlag,
			String forwardAddress, ArrayList oidList) {

		Document dom = TrapForwardResourceFileParse.getInstance()
				.updateDocument(forwardFlag, forwardAddress, oidList);

		return dom;
	}
}
