/*
 * Created on 2004/11/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;
import netjfwatcher.snmpmanager.SnmpManagerQueue;



/**
 * TrapM҂AMɂSNMP VesionɑΉ鏈ɐU
 * NXłB
 * TrapMThreadĂ΂܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapDispatcher extends DataStringDisplay {
    /* MO */
    private static Logger logger;

    /**
     * Trap DispatcherCX^X𐶐܂B
     *
     */
    public TrapDispatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * TrapMf[^Snmp VersionɃfBXpb`܂B
     *
     * @param dSocket TrapMDatagramSocket
     * @param listenerList TrapMXi[o^ꂽXg
     * @throws SnmpV3ConfigurationException SNMP V3\`Ɉُ킪ꍇ
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpBadValueException SNMPIuWFNgňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException ňُ킪ꍇ
     * @throws IOException Mňُ킪ꍇ
     */
    public void disptcher(
        final DatagramSocket dSocket, final List listenerList)
        throws SnmpV3ConfigurationException, GeneralSecurityException,
            SnmpBadValueException, SnmpV3DecryptAbortException, IOException {
        /* TrapMDatagramPacket */
        DatagramPacket inDatagramPacket =
            new DatagramPacket(
                new byte[SnmpPreference.IN_DATA_PACKET_MAX],
                SnmpPreference.IN_DATA_PACKET_MAX);

        /*
         * TrapM҂
         */
        dSocket.receive(inDatagramPacket);

        /* Mf[^o */
        byte[] encodedMessage = inDatagramPacket.getData();

        /* MonitorTrapMf[^\ */
        Date date = Calendar.getInstance().getTime();
        DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");
        logger.info(
            "Receive Trap date : " + dateformat.format(date)
            + " : Data length : " + inDatagramPacket.getLength() + "Byte");
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Receive Trap date : " + dateformat.format(date)
            + " : Data length : " + inDatagramPacket.getLength() + "Byte");
        logger.info(
            hexBytetoString(encodedMessage, inDatagramPacket.getLength()));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            hexBytetoString(encodedMessage, inDatagramPacket.getLength()));

        /* Mf[^ASN.1 GR[h */
        SnmpMessage receivedMessage = new SnmpMessage();
        SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
        receivedMessage.setTLV(nextTLV);

        /*
         * SNMP Versiono
         *
         */
        byte[] versionData = receivedMessage.getVersion();
        int trapSnmpVersion = versionData[0];
        logger.info("Trap Version : " + getVesionDiscrip(trapSnmpVersion));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue(
            "Trap Version : " + hexByte(versionData[0]) + "("
            + getVesionDiscrip(trapSnmpVersion) + ")");

        /*
         * SNMPR}hR[ho
         *
         */
        byte snmpCommandCode = receivedMessage.getCommand();

        /*
         * TrapMAgnetAhXo
         */
        String agentAddress = inDatagramPacket.getAddress().getHostName();

        /* Snmp Vesionɂ菈fBXpb` */
        switch (versionData[0]) {
        case SnmpPreference.SNMP_VERSION_1:

            /*
             * R}hR[h`FbN
             * (R}hR[h(Trap PDU Type)VerisonÓ)
             */
            if (snmpCommandCode == SnmpBERCodec.SNMPTRAP) {
                logger.info(
                    "SNMP Ver.1 Trap(0xA4) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            } else if (snmpCommandCode == SnmpBERCodec.SNMPTRAP2) {
                logger.warning(
                    "SNMP Ver.1 TarpV2(0xA7) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            }

            /* Snmp V1 Traps*/
            TrapV1ReceiveMP mp = new TrapV1ReceiveMP();
            mp.process(agentAddress, encodedMessage, listenerList);

            break;

        case SnmpPreference.SNMPV2C:

            if (snmpCommandCode == SnmpBERCodec.SNMPTRAP) {
                logger.info(
                    "SNMP Ver.2 Trap(0xA4) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            } else if (snmpCommandCode == SnmpBERCodec.SNMPTRAP2) {
                logger.warning(
                    "SNMP Ver.2 TarpV2(0xA7) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            }

            TrapV2ReceiveMP mp2 = new TrapV2ReceiveMP();
            mp2.process(agentAddress, encodedMessage, listenerList);

            break;

        case SnmpPreference.SNMPV3:

            if (snmpCommandCode == SnmpBERCodec.SNMPTRAP) {
                logger.info(
                    "SNMP Ver.3 Trap(0xA4) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            } else if (snmpCommandCode == SnmpBERCodec.SNMPTRAP2) {
                logger.warning(
                    "SNMP Ver.3 TarpV2(0xA7) Receive : "
                    + hexByte(snmpCommandCode) + "("
                    + getCommandDescription(snmpCommandCode) + ")" + " from "
                    + agentAddress);
            }

            TrapV3ReceiveMP mp3 = new TrapV3ReceiveMP();
            mp3.process(agentAddress, encodedMessage, listenerList);

            break;

        default:
            logger.warning("Unknown SNMP Trap version : " + versionData[0]);
        }
    }

    /*
     * SNMo[WR[hɑΉDescriptionԂ܂B
     *
     * @param version SNMo[WR[h
     * @return SNMo[WR[hɑΉDescription
     */
    private String getVesionDiscrip(int version) {
        String snmpVersion = "";

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            snmpVersion = "SnmpV1";

            break;

        case SnmpPreference.SNMPV2C:
            snmpVersion = "SnmpV2c";

            break;

        case SnmpPreference.SNMPV3:
            snmpVersion = "SnmpV3";

            break;

        default:
            logger.warning("Bad Snmp version: " + version);
        }

        return snmpVersion;
    }

    /*
     * SNMPR}hMOs܂B
     *
     * @param code
     */
    private String getCommandDescription(byte code) {
        String snmpCode = "";

        switch (code) {
        case SnmpBERCodec.SNMPTRAP:
            snmpCode = SnmpBERCodec.COMMAND_TRAP_PDU_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPTRAP2:
            snmpCode = SnmpBERCodec.COMMAND_TRAP2_PDU_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPINFORM:
            snmpCode = SnmpBERCodec.COMMAND_INFORM_PDU_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPGETREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_GET_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_GET_NEXT_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPSETREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_SET_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPGETRESPONSE:
            snmpCode = SnmpBERCodec.COMMAND_GET_RESPONSE_DESCRIPTION;

            break;

        default:
            snmpCode = "Unknown";
            logger.warning("Undefined SNMP Command code : " + code);
        }

        return snmpCode;
    }
}
