/*
 * Created on 2007/01/30
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.process.AgentDispatcher;

public class TrapForward {

	private boolean isForward = true;
	private String forwardAddress;
	private HashMap enterpriseOIDHashMap;
	private String privateOID;
	private static Logger logger;

	private TrapForward() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public String extractEnterpriseOid(String privateOID) {
		String returnEnterpriseOid = null;
		String keyOid = "1.3.6.1.4.1.";
		int pos = privateOID.indexOf(keyOid);
		if(pos < 0) {
			return returnEnterpriseOid;
		}
		String workOid = privateOID.substring(keyOid.length());
		String [] arrayOid = workOid.split("[.]");
		if(arrayOid == null || arrayOid.length <= 0) {
			return returnEnterpriseOid;
		}
		returnEnterpriseOid = arrayOid[0];
		return returnEnterpriseOid;
	}
	
	public boolean filterTrapForward(String privateOID) {
	
		if(TrapForwardResourceFileParse.getInstance().getForwardFlag().equals("true")) {
			isForward = true;
		} else {
			isForward = false;
			return isForward;
		}
		

		this.privateOID = privateOID;
		if(privateOID == null) {
			return false;
		}
		
		enterpriseOIDHashMap = TrapForwardResourceFileParse.getInstance().getEnterpriseOidHashMap();
				
		if(enterpriseOIDHashMap.size() == 0) {
			return true;
		}
		
		if(enterpriseOIDHashMap.containsKey(privateOID)) {
			return true;
		} else {
			return false;
		}

	}
	
	
	public void forwardTrap(final String community, final SnmpSequence trapPDUSequence,
			 final int version, final String sourceAddress) {

		forwardAddress = TrapForwardResourceFileParse.getInstance().getForwardAddress();
		String hostAddress = "";

		try {
			InetAddress host = InetAddress.getByName(forwardAddress);
			hostAddress = host.getHostAddress();
		} catch (UnknownHostException e2) {
			logger.warning(e2.getMessage());
			return;
		}

		try {

			if (trapPDUSequence != null) {
				// Trap]
				AgentDispatcher dispacher = new AgentDispatcher();
				dispacher.dispacherTrapSend(hostAddress, version, community,
						trapPDUSequence);
				logger.info("Trap forward Destination Address=" + hostAddress + " Source Address=" + sourceAddress + " Enterprise Private OID=" + privateOID);

			}
		} catch (SocketException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (UnknownHostException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (SnmpV3ConfigurationException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (GeneralSecurityException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (SnmpBadValueException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (IOException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		}
	}

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TrapForward getInstance() {
        return SingletonResource.TRAP_FORWARD_IMPL;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TrapForward TRAP_FORWARD_IMPL =
            new TrapForward();
    }
    
}
