/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;



/**
 * SNMP V1 TrapM\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapV1ReceiveMP extends AbstractTrapMessageProcessing {
    /* MO */
    private static Logger logger;

    /**
     * Snmp V1 TrapMCX^X𐶐܂B
     *
     */
    public TrapV1ReceiveMP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Snmp TrapMłdisptcherSnmp V1̏ꍇɋNA
     * Mf[^͂ATrapMXi[o^ꂢ郊Xg
     * Xi[ǂݏoAtrapMƂẴe[u\Ȃǂs܂B
     *
     * @param agentAddress TrapM̃G[WFgAhX
     * @param encodedMessage Mf[^
     * @param listenerList TrapMXi[o^ꂽXg
     * @throws SnmpBadValueException Mf[^͂Ɏsꍇ
     */
    public final void process(
        final String agentAddress, final byte[] encodedMessage,
        final List listenerList) throws SnmpBadValueException {
        logger.info("Snmp V1 Trap : " + agentAddress);

        /*
         * MoCgf[^Snmp Message
         */
        SnmpMessage receivedMessage = new SnmpMessage();
        SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
        receivedMessage.setTLV(nextTLV);

        /* MmessageTrap PDUo */
        SnmpTrapPDU receivedTrapPDU = receivedMessage.getTrapPDU();
        byte [] communityByte = receivedMessage.getCommunity();
        String community = bytetoChar(communityByte);
        /*
         * TrapMXi[o^Ă郊Xg烊Xi[ǂݏo
         *
         */
        for (int i = 0; i < listenerList.size(); i++) {
            /* Xi[ɎĂTrapMs */
            ITrapListener listener = (ITrapListener) listenerList.get(i);

            listener.processTrap(community, receivedTrapPDU, agentAddress);
        }
    }
}
