/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.nodemaneger.map.NodeMapView;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewMouseListener;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/**
 * lbg[NoRŃm[hMap\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientNodeMapView extends NodeMapView {
	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(final Composite parent) {
		setCanvasSize();
		/*
		 * ColorIuWFNgjĂꍇ͍ăZbg
		 */
		if ((whiteColor == null) || whiteColor.isDisposed()) {
			whiteColor = new Color(null, 255, 255, 255);
		}

		if ((blackColor == null) || blackColor.isDisposed()) {
			blackColor = new Color(null, 0, 0, 0);
		}

		if ((redColor == null) || redColor.isDisposed()) {
			redColor = new Color(null, 255, 0, 0);
		}

		display = parent.getDisplay();

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, true);
		scrollComposite.setLayout(layout);

		canvas = new Canvas(scrollComposite, SWT.NULL);

		gc = new GC(canvas);

		scrollComposite.setBackground(whiteColor);
		gc.setBackground(scrollComposite.getBackground());
		scrollComposite.setContent(canvas);
		scrollComposite
				.setMinSize(nodeMapViewSize[0], nodeMapViewSize[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());

		mouseListener = new NodeMapViewMouseListener(scrollComposite, display,
				parent, canvas, gc, statusLineManager, true);
		mouseListener.getPopMenu().setPopUpMenu(parent);
		canvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent e) {
				mouseListener.redraw();
			}
		});

		/*
		 * Canvas MouseXi[Zbg
		 */
		canvas.addMouseListener(mouseListener);

		/*
		 * m[hړ܂Link`揈
		 */
		canvas.addMouseMoveListener(mouseListener);
		setToolBarActions();
	}

	/**
	 * ANV̏s܂B
	 * 
	 */
	protected void setToolBarActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();
		toolBarManager.add(new ActionLoadNodeMapView());

		/* m[hĎ񃊃XgC|[gANV */
		toolBarManager.add(nodeListAction.getActionImportNodeListFileSocket());

		/* m[hĎ񃊃XgGNX|[gANV */
		toolBarManager.add(nodeListAction.getActionExportNodeListFileSocket());

		/* Sm[hAlarm\ANV */
		toolBarManager.add(actionBuilderAlarm
				.getActionShowAllNodeAlarmListTableSocket());

		/* Editor part closeANV */
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}
}
