/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.menutree;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;


/**
 * Menu Treer[ContentProviderNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractNetMenuTreeViewContentProvider
    implements ITreeContentProvider {

    public AbstractNetMenuTreeViewContentProvider() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITreeContentProvider#getChildren(java.lang.Object)
     */
    public Object[] getChildren(Object parentElement) {
        IMenuNode node = (IMenuNode) parentElement;

        return node.getChildren();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITreeContentProvider#getParent(java.lang.Object)
     */
    public Object getParent(Object element) {
        IMenuNode node = (IMenuNode) element;

        return node.getParent();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * ITreeContentProvider#hasChildren(java.lang.Object)
     */
    public boolean hasChildren(Object element) {
        IMenuNode node = (IMenuNode) element;

        return node.hasChildren();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}
