/*
 * Created on 2005/04/14
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.menutree;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;


/**
 * lbg[Nj[TreeɂO[v\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetMenuTreeGroup extends AbstractMenuNode {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;
    /*
     * O[vɏqm[hێMap
     */
    private Set children = new HashSet();

    /**
     * lbg[Nj[TreeɂO[v\NX
     * CX^X𐶐܂B
     */
    public NetMenuTreeGroup() {
    }

    /**
     * lbg[Nj[TreeɂO[v\NX
     * CX^Xw肵O[vɂĐ܂B
     *
     * @param name O[v
     */
    public NetMenuTreeGroup(String name) {
        setName(name);
    }

    /**
     * qm[hԂ܂B
     *
     * @return qm[h
     */
    public IMenuNode[] getChildren() {
        return (IMenuNode[]) children.toArray(new IMenuNode[children.size()]);
    }

    /**
     * ImageԂ܂B
     *
     * @return Image
     */
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage(
            ISharedImages.IMG_OBJ_FOLDER);
    }

    /**
     * qm[hǉ܂B
     *
     * @param toAdd ǉqm[h
     */
    public void addChild(IMenuNode toAdd) {
        children.add(toAdd);
        toAdd.setParent(this);
    }

    /**
     * O[vǉ܂B
     *
     * @param toAddGroup ǉO[v
     * @return toAddGroup ǉO[v
     */
    public NetMenuTreeGroup addGroup(NetMenuTreeGroup toAddGroup) {
        children.add(toAddGroup);
        toAddGroup.setParent(this);

        return toAddGroup;
    }

    /**
     * qm[h݂邩Ԃ܂B
     *
     * @return qm[h݂邩tO
     */
    public boolean hasChildren() {
        return !children.isEmpty();
    }

    /**
     * qm[h폜܂B
     *
     * @param toRemove 폜qm[h
     */
    public void removeChild(IMenuNode toRemove) {
        children.remove(toRemove);
    }

    /**
     * SĂ̎qm[h폜܂B
     *
     */
    public void removeChildAll() {
        children.clear();
    }
}
