/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.nodetree;

import java.util.logging.Logger;

import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;


/**
 * m[hTreeIXi[NXłB
 * m[hTreeIɂAm[hViewuEUŕ\܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTreeListener implements ISelectionChangedListener {
    /* IWorkbenchPage */
    private static IWorkbenchPage activePage;

    /* MO */
    private static Logger logger = null;
    private static String accessURL = null;

    /**
     * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
     * ̃Cxg_@ƂWebɃANZX
     *
     * @param event SelectionChangedEvent
     */
    public void selectionChanged(SelectionChangedEvent event) {
        logger = Logger.getLogger(this.getClass().getName());

        //
        StructuredSelection ss = (StructuredSelection) event.getSelection();

        // m[hGroup̏ꍇɂ̓uEUopenreturn
        logger.info("Tree node  select : " + ss.getFirstElement());

        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");

            return;
        } else if (!(ss.getFirstElement() instanceof NodeTree)) {
            logger.info("No NodeTree ");

            return;
        }

        final NodeTree entry = (NodeTree) ss.getFirstElement();

        try {
            accessURL = entry.getUrl();
        } catch (HttpAccessPreferenceException e1) {
            // TODO Auto-generated catch block
            e1.printStackTrace();
        }

        logger.info("Name : " + entry.getName());
        logger.info("Url : " + accessURL);

        /*
         * Browser Editorclose
         */
        activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        IEditorPart editorPart =
            BrowserEditorsManager.getInstance().getBrowserEditors(accessURL);

        if (editorPart != null) {
            BrowserEditorsManager.getInstance().removetBrowserEditors(
                accessURL);
            activePage.closeEditor(editorPart, false);
        }

        if (accessURL != null) {
            /*
             * IꂽGg̃m[hURLEditorɃuEU
             * I[v
             * EditorID̓uEŨNX
             */
            BusyIndicator.showWhile(
                PlatformUI.getWorkbench().getDisplay(),
                new Runnable() {
                    public void run() {
                        try {
                            IEditorPart editorPart =
                                activePage.openEditor(
                                    new UrlEditorInput(
                                        entry.getName(), accessURL),
                                    BrowserEditors.class.getName());

                            BrowserEditorsManager.getInstance()
                                                 .setBrowserEditors(
                                accessURL, editorPart);
                        } catch (PartInitException e) {
                            logger.warning(
                                "Menu open error : " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
        } else {
            logger.warning("Error entry url null");
        }
    }
}
