/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.ui.IEditorPart;


/**
 * Editor Partsɕ\uEU\ێNXłB
 * uEU\URLKeyƂāAuEU\EditorPartCX^X
 * ێ܂B
 * uEU\ɂĊɓURLɂuEU\Ȃ
 * ꍇɁAuEU\Editor PartsUCloseĂ\
 * ߂Ɏgp܂B
 *
 * ́AuEU\uEȖɂωĂꍇA
 * URL\邽߂łB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class BrowserEditorsManager {

    /* URLKeyƂuEU\EditorPartCX^XێMap */
    private static Map browserEditorsMap =
        Collections.synchronizedMap(new HashMap());

    /*
     * Editor Partsɕ\uEU\ێNX
     * CX^X𐶐܂B
     */
    private BrowserEditorsManager() {
    }

    /**
     * URLKeyƂAuEU\EditorPartCX^XMap
     * i[܂B
     *
     * @param url URL
     * @param editorPart uEU\EditorPartCX^X
     */
    public void setBrowserEditors(String url, IEditorPart editorPart) {
        browserEditorsMap.put(url, editorPart);
    }

    /**
     * wURLɑΉuEU\EditorPartCX^X
     * Ԃ܂B
     *
     * @param url URL
     * @return IEditorPart uEU\EditorPartCX^X
     */
    public IEditorPart getBrowserEditors(String url) {
        return (IEditorPart) browserEditorsMap.get(url);
    }

    /**
     * URLKeyƂAuEU\EditorPartCX^XMap
     * 폜܂B
     *
     * @param url URL
     */
    public void removetBrowserEditors(String url) {
        browserEditorsMap.remove(url);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static BrowserEditorsManager getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final BrowserEditorsManager INSTANCE =
            new BrowserEditorsManager();
    }
}
