/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.jetty.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.jetty.plugin.NetWatchRCPJettyPlugin;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class JettyConfigFileParse {
    public static final String CONF = "jetty_conf";
    public static final String WEBAPP_WAR = "webAppContext_War";
    public static final String CONNECTOR_PORT = "connector_port";
    public static final String CONTEXT_PATH = "contextPath";
    public static final String USER_REALM_NAME = "userRealmName";
    public static final String USER_REALM_PATH = "userRealmPath";
    public static final String TMP_DIR = "webAppTempDirectory";
    public static final String XML_FILE_VALUE = "value";
    private static Logger logger = null;
    private String webAppContext_War;
    private String connector_port;
    private String contextPath;
    private String userRealmName;
    private String userRealmPath;
    private String tempDirectory;

    public JettyConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        Document doc = null;
        doc = this.getDocument("resources/jetty_conf.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        Element root = doc.getRootElement();
        this.webAppContext_War = root.getChild(this.webAppContext_War).getAttributeValue(XML_FILE_VALUE);
        this.connector_port = root.getChild(CONNECTOR_PORT).getAttributeValue(XML_FILE_VALUE);
        this.contextPath = root.getChild(CONTEXT_PATH).getAttributeValue(XML_FILE_VALUE);
        this.userRealmName = root.getChild(USER_REALM_NAME).getAttributeValue(XML_FILE_VALUE);
        this.userRealmPath = root.getChild(USER_REALM_PATH).getAttributeValue(XML_FILE_VALUE);
        this.tempDirectory = root.getChild(TMP_DIR).getAttributeValue(XML_FILE_VALUE);
    }

    public BufferedWriter getResourceFileWriter() {
        File f = new File("");
        logger.info("Path : " + f.getAbsolutePath());
        if (f == null) {
            return null;
        }
        BufferedWriter bufferedWriter = null;
        try {
            FileWriter fi = new FileWriter("");
            bufferedWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return bufferedWriter;
    }

    public Document getResourceFileDocumentPath(String file) {
        SAXBuilder builder;
        BufferedReader d;
        Document doc;
        block7: {
            doc = null;
            File f = new File(file);
            logger.info("Path : " + f.getAbsolutePath());
            if (f == null) {
                return null;
            }
            d = null;
            try {
                FileReader fi = new FileReader(file);
                d = new BufferedReader(fi);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                return null;
            }
            builder = new SAXBuilder();
            if (builder != null) break block7;
            return null;
        }
        try {
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            Bundle bundle = NetWatchRCPJettyPlugin.getDefault().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }
        return doc;
    }

    public String getConnector_port() {
        return this.connector_port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getUserRealmName() {
        return this.userRealmName;
    }

    public String getUserRealmPath() {
        return this.userRealmPath;
    }

    public String getWebAppContext_War() {
        return this.webAppContext_War;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setConnector_port(String connector_port) {
        this.connector_port = connector_port;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setUserRealmName(String userRealmName) {
        this.userRealmName = userRealmName;
    }

    public void setUserRealmPath(String userRealmPath) {
        this.userRealmPath = userRealmPath;
    }

    public void setWebAppContext_War(String webAppContext_War) {
        this.webAppContext_War = webAppContext_War;
    }
}

