/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.mortbay.component.Container;
import org.mortbay.component.LifeCycle;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.log.Log;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiException;

public class Server
extends HandlerWrapper
implements Attributes {
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private UserRealm[] _realms;
    private Container _container = new Container();
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private AttributesMap _attributes = new AttributesMap();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
        this.setServer(this);
    }

    public Server(int port) {
        this.setServer(this);
        SocketConnector connector = new SocketConnector();
        connector.setPort(8080);
        this.setConnectors(new Connector[]{connector});
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray((Object[])this.getConnectors(), (Object)connector, (Class)Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray((Object[])this.getConnectors(), (Object)connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    protected void doStart() throws Exception {
        if (this.getClass().getPackage().getImplementationVersion() == null) {
            Log.info((String)"Jetty 6.0.x");
        } else {
            Log.info((String)(this.getClass().getPackage().getImplementationTitle() + " " + this.getClass().getPackage().getImplementationVersion()));
        }
        MultiException mex = new MultiException();
        if (this._threadPool == null) {
            BoundedThreadPool btp = new BoundedThreadPool();
            this.setThreadPool(btp);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.start();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        MultiException mex = new MultiException();
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.stop();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        if (Log.isDebugEnabled()) {
            Log.debug((String)("REQUEST " + target + " on " + connection));
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
            Log.debug((String)("RESPONSE " + target + "  " + connection.getResponse().getStatus()));
        } else {
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public UserRealm[] getUserRealms() {
        return this._realms;
    }

    public void setUserRealms(UserRealm[] realms) {
        this._container.update((Object)this, this._realms, realms, "realm", true);
        this._realms = realms;
    }

    public void addUserRealm(UserRealm realm) {
        this.setUserRealms((UserRealm[])LazyList.addToArray((Object[])this.getUserRealms(), (Object)realm, (Class)UserRealm.class));
    }

    public void removeUserRealm(UserRealm realm) {
        this.setUserRealms((UserRealm[])LazyList.removeFromArray((Object[])this.getUserRealms(), (Object)realm));
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._container.update((Object)this, this._sessionIdManager, sessionIdManager, "sessionIdManager", true);
        this._sessionIdManager = sessionIdManager;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void addHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).addHandler(handler);
        } else {
            HandlerCollection collection = new HandlerCollection();
            collection.setHandlers(new Handler[]{this.getHandler(), handler});
            this.setHandler(collection);
        }
    }

    public void removeHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).removeHandler(handler);
        }
    }

    public Handler[] getHandlers() {
        if (this.getHandler() instanceof HandlerCollection) {
            return ((HandlerCollection)this.getHandler()).getHandlers();
        }
        return null;
    }

    public void setHandlers(Handler[] handlers) {
        HandlerCollection collection;
        if (this.getHandler() instanceof HandlerCollection) {
            collection = (HandlerCollection)this.getHandler();
        } else {
            collection = new HandlerCollection();
            this.setHandler(collection);
        }
        collection.setHandlers(handlers);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug((String)"No shutdown hook in JVM ", (Object)e);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection c) {
            this.createShutdownHook();
            return this.servers.addAll(c);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection c) {
            this.createShutdownHook();
            return this.servers.removeAll(c);
        }

        public void run() {
            this.setName("Shutdown");
            Log.info((String)"Shutdown hook executing");
            Iterator it = this.servers.iterator();
            while (it.hasNext()) {
                Server svr = (Server)it.next();
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
                Log.info((String)"Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Log.warn((Throwable)e);
                }
            }
        }
    }
}

