/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Loader;
import org.mortbay.xml.XmlParser;

public class TagLibConfiguration
implements Configuration {
    WebAppContext _context;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public WebAppContext getWebAppContext() {
        return this._context;
    }

    public void configureClassLoader() throws Exception {
    }

    public void configureDefaults() throws Exception {
    }

    protected List getJarResourceList() throws MalformedURLException, IOException {
        Resource lib;
        ArrayList<Resource> list = new ArrayList<Resource>();
        Resource web_inf = this._context.getWebInf();
        if (web_inf != null && web_inf.exists() && (lib = web_inf.addPath("lib/")).exists() && lib.isDirectory()) {
            String[] contents = lib.list();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".jar")) continue;
                list.add(lib.addPath(contents[i]));
            }
        }
        return list;
    }

    private void findTLDs(Set tlds, Resource dir) throws MalformedURLException, IOException {
        String[] meta_contents = dir.list();
        for (int j = 0; j < meta_contents.length; ++j) {
            Resource r = dir.addPath(meta_contents[j]);
            if (r.isDirectory()) {
                this.findTLDs(tlds, r);
                continue;
            }
            if (!meta_contents[j].toLowerCase().endsWith(".tld")) continue;
            tlds.add(r);
        }
    }

    public void configureWebApp() throws Exception {
        Resource web_inf;
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (this._context.getResourceAliases() != null && this._context.getBaseResource() != null && this._context.getBaseResource().exists()) {
            Iterator iter = this._context.getResourceAliases().values().iterator();
            while (iter.hasNext()) {
                String location = (String)iter.next();
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                Resource l = this._context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if ((web_inf = this._context.getWebInf()) != null) {
            String[] contents = web_inf.list();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                Resource l = this._context.getWebInf().addPath(contents[i]);
                tlds.add(l);
            }
        }
        List jars = this.getJarResourceList();
        for (int i = 0; i < jars.size(); ++i) {
            Resource jar = (Resource)jars.get(i);
            Resource meta = Resource.newResource("jar:" + jar.getURL() + "!/META-INF/");
            if (!meta.exists()) continue;
            this.findTLDs(tlds, meta);
        }
        XmlParser parser = new XmlParser(false);
        parser.redirectEntity("web-jsptaglib_1_1.dtd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)false));
        parser.redirectEntity("web-jsptaglib_1_2.dtd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)false));
        parser.redirectEntity("web-jsptaglib_2_0.xsd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)false));
        parser.redirectEntity("web-jsptaglibrary_1_1.dtd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)false));
        parser.redirectEntity("web-jsptaglibrary_1_2.dtd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)false));
        parser.redirectEntity("web-jsptaglibrary_2_0.xsd", Loader.getResource((Class)TagLibConfiguration.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)false));
        parser.setXpath("/taglib/listener/listener-class");
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                Resource tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("TLD=" + tld));
                }
                XmlParser.Node root = parser.parse(tld.getURL().toString());
                for (int i = 0; i < root.size(); ++i) {
                    XmlParser.Node node;
                    Object o = root.get(i);
                    if (!(o instanceof XmlParser.Node) || !"listener".equals((node = (XmlParser.Node)o).getTag())) continue;
                    String className = node.getString("listener-class", false, true);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("listener=" + className));
                    }
                    try {
                        Class listenerClass = this.getWebAppContext().loadClass(className);
                        EventListener l = (EventListener)listenerClass.newInstance();
                        this._context.addEventListener(l);
                        continue;
                    }
                    catch (Exception e) {
                        Log.warn((String)("Could not instantiate listener " + className), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public void deconfigureWebApp() throws Exception {
    }
}

