/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.webapp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.mortbay.io.IO;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;

public class WebAppClassLoader
extends URLClassLoader {
    private WebAppContext _context;
    private ClassLoader _parent;
    private String _urlClassPath;

    public WebAppClassLoader(ClassLoader parent, WebAppContext context) {
        super(new URL[0], parent);
        this._parent = parent;
        this._context = context;
        if (parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            URL url;
            Resource resource;
            block9: {
                File lib;
                File file;
                resource = Resource.newResource(tokenizer.nextToken());
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Path resource=" + resource));
                }
                if ((file = resource.getFile()) != null) {
                    url = resource.getURL();
                    this.addURL(url);
                    this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
                    continue;
                }
                if (resource.isDirectory() || file != null) break block9;
                InputStream in = resource.getInputStream();
                File tmp_dir = this._context.getTempDirectory();
                if (tmp_dir == null) {
                    tmp_dir = File.createTempFile("jetty.cl.lib", null);
                    tmp_dir.mkdir();
                    tmp_dir.deleteOnExit();
                }
                if (!(lib = new File(tmp_dir, "lib")).exists()) {
                    lib.mkdir();
                    lib.deleteOnExit();
                }
                File jar = File.createTempFile("Jetty-", ".jar", lib);
                jar.deleteOnExit();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Extract " + resource + " to " + jar));
                }
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(jar);
                    IO.copy(in, out);
                }
                catch (Throwable throwable) {
                    IO.close(out);
                    throw throwable;
                }
                IO.close(out);
                URL url2 = jar.toURL();
                this.addURL(url2);
                this._urlClassPath = this._urlClassPath == null ? url2.toString() : this._urlClassPath + "," + url2.toString();
                continue;
            }
            url = resource.getURL();
            this.addURL(url);
            this._urlClassPath = this._urlClassPath == null ? url.toString() : this._urlClassPath + "," + url.toString();
        }
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (!fnlc.endsWith(".jar") && !fnlc.endsWith(".zip")) continue;
                    this.addClassPath(fn.toString());
                    continue;
                }
                catch (Exception ex) {
                    Log.warn((String)"EXCEPTION ", (Throwable)ex);
                }
            }
        }
    }

    public void destroy() {
        this._parent = null;
        this._urlClassPath = null;
    }

    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    public synchronized URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        if (this._context.isParentLoaderPriority() || this.isSystemPath(name)) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("HACK leading / off " + name));
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null && !tried_parent && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && Log.isDebugEnabled()) {
            Log.debug((String)("getResource(" + name + ")=" + url));
        }
        return url;
    }

    public String getUrlClassPath() {
        return this._urlClassPath;
    }

    public boolean isServerPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] server_classes = this._context.getServerClasses();
        if (server_classes != null) {
            for (int i = 0; i < server_classes.length; ++i) {
                boolean result = true;
                String c = server_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] system_classes = this._context.getSystemClasses();
        if (system_classes != null) {
            for (int i = 0; i < system_classes.length; ++i) {
                boolean result = true;
                String c = system_classes[i];
                if (c.startsWith("-")) {
                    c = c.substring(1);
                    result = false;
                }
                if (!(c.endsWith(".") ? name.startsWith(c) : name.equals(c))) continue;
                return result;
            }
        }
        return false;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || this.isSystemPath(name))) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent && !this.isServerPath(name)) {
            c = this._parent.loadClass(name);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("loaded " + c + " from " + c.getClassLoader()));
        }
        return c;
    }

    public String toString() {
        if (Log.isDebugEnabled()) {
            return "ContextLoader@" + this.hashCode() + "(" + this._urlClassPath + ") / " + this._parent;
        }
        return "ContextLoader@" + this.hashCode();
    }
}

