/*
 * Created on 2006/08/17
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 *
 */
package netjfwatcher.jetty.control;

import java.util.logging.Logger;


/**
 * JettyT[o𐧌䂷ThreadNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class JettyServerThread implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger;
    private Thread jettyServerThread;

    private String message = "";
    private JettyServerThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public boolean checkThread() {
        if ((jettyServerThread == null) || !jettyServerThread.isAlive()) {
            return false;
        }

        return true;
    }

    public boolean startJettyServerThread() throws JettyException {
    	message = "";
        if ((jettyServerThread == null) || !jettyServerThread.isAlive()) {
            jettyServerThread = new Thread(this);

            if (jettyServerThread != null) {
                JettyControl.getInstance().setJettyServerConf();
                jettyServerThread.start();
            }

            return true;
        }

        return false;
    }

    public void stopJettyServerThread() throws JettyException {
    	message = "";
        if (jettyServerThread == null) {
            return;
        }

        JettyControl.getInstance().stopJettyServer();

        // interrupt receive thread so it will die a natural death
        jettyServerThread.interrupt();

        /* Thread~܂Loop */
        while ((jettyServerThread != null) && jettyServerThread.isAlive()) {
            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }

        jettyServerThread = null;
    }

    /**
     * TrapM҂XbhłB
     * ۂTrapMSNMP VersioñfBXpb`[ōs܂
     *
     */
    public void run() {
        try {
            JettyControl.getInstance().startJettyServer();
        } catch (JettyException e) {
        	message = e.getMessage();
            logger.warning(e.getMessage());
            e.printStackTrace();

            return;
        }

        while (
            (jettyServerThread != null) && !jettyServerThread.isInterrupted()) {
        	
            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                break;
            }
        }

        logger.info("Jetty server thread interrupted");
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static JettyServerThread getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final JettyServerThread RESOURCE = new JettyServerThread();
    }

	public String getMessage() {
		return message;
	}
}
