/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.jetty.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.jetty.plugin.NetWatchRCPJettyPlugin;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

/**
 * Jetty\`XMLt@C̉͂sNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class JettyConfigFileParse {
    /** XML File Conf ^O */
    public static final String CONF = "jetty_conf";

    /** XML Web App Contect war Tag */
    public static final String WEBAPP_WAR = "webAppContext_War";

    /** XML Connector port Tag */
    public static final String CONNECTOR_PORT = "connector_port";

    /** XML Context Path Tag */
    public static final String CONTEXT_PATH = "contextPath";

    /** XML User Realm Name Tag */
    public static final String USER_REALM_NAME = "userRealmName";
    /** XML User Realm Path Tag */
    public static final String USER_REALM_PATH = "userRealmPath";
    /** XML Temp Directory Tag */
    public static final String TMP_DIR = "webAppTempDirectory";
    /** \[XXML l^O */
    public static final String XML_FILE_VALUE = "value";

    /* Logging */
    private static Logger logger = null;
    private String webAppContext_War;
    private String connector_port;
    private String contextPath;
    private String userRealmName;
    private String userRealmPath;
    private String tempDirectory;

    /**
     *
     * ŏɎwfBNgt@C͂邩GW
     * \[X擾܂B
     * wfBNg擾łȂꍇ́AGW
     * \[X擾܂B
     *
     * @throws Exception \[X͂ňُ킪ꍇ
     */
    public JettyConfigFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = null;

        // jart@C邩fBNgwt@C擾邩
        doc = getDocument(Preference.JETTY_CONF_FILE);

        // doc = getResourceFileDocumentPath(Preference.JETTY_CONF_FILE);
        if (doc == null) {
            logger.severe("Resource File Doc null ");

            return;
        }

        Element root = doc.getRootElement();
        webAppContext_War =
            (root.getChild(webAppContext_War)).getAttributeValue(
                XML_FILE_VALUE);
        connector_port =
            (root.getChild(CONNECTOR_PORT)).getAttributeValue(XML_FILE_VALUE);

        contextPath =
            (root.getChild(CONTEXT_PATH)).getAttributeValue(XML_FILE_VALUE);

        userRealmName =
            (root.getChild(USER_REALM_NAME)).getAttributeValue(XML_FILE_VALUE);
        userRealmPath =
            (root.getChild(USER_REALM_PATH)).getAttributeValue(XML_FILE_VALUE);
        tempDirectory = (root.getChild(TMP_DIR)).getAttributeValue(XML_FILE_VALUE);
        /*
        logger.info("webAppContext_War " + webAppContext_War);
        logger.info("connector_port " + connector_port);
        logger.info("contextPath " + contextPath);
        logger.info("userRealmPath " + userRealmPath);
        */
    }

    /**
     * SNMP V3}l[WBufferedWriterԂ܂B
     *
     * @return bufferedWriter BufferedWriter
     */
    public BufferedWriter getResourceFileWriter() {
        File f = new File("");
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedWriter bufferedWriter = null;

        try {
            FileWriter fi = new FileWriter("");
            bufferedWriter = new BufferedWriter(fi);
        } catch (IOException e1) {
            e1.printStackTrace();

            return null;
        }

        return bufferedWriter;
    }

    /**
     * wfBNgXMLt@C͂DocumentԂ܂B
     * ijart@ČȂj
     *
     * @param file XMLt@C
     * @return doc Document
     */
    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;

        File f = new File(file);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedReader d = null;

        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();

            return null;
        }

        try {
            // FileInputStream stream = new FileInputStream(f);
            SAXBuilder builder = new SAXBuilder();

            if (builder == null) {
                return null;
            }

            doc = builder.build(d);
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * jart@CXMLt@CE͂DocumentԂ܂B
     *
     * @param file XMLt@C
     * @return doc Document
     */
    protected Document getDocument(String file) {
        Document doc = null;

        URL url = null;

        try {
            Bundle bundle = NetWatchRCPJettyPlugin.getDefault().getBundle();

            url = bundle.getEntry(file);

            if (url == null) {
                /* bZ[W\[Xt@CȂꍇMO̎ */
                logger.severe("Resource XML file url : " + url);

                return null;
            }

            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        } catch (JDOMException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        } catch (NullPointerException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        } catch (IOException e) {
            logger.severe("Resource XML file url : " + url);
            e.printStackTrace();
        }

        return doc;
    }

	public String getConnector_port() {
		return connector_port;
	}

	public String getContextPath() {
		return contextPath;
	}

	public String getUserRealmName() {
		return userRealmName;
	}
	
	public String getUserRealmPath() {
		return userRealmPath;
	}

	public String getWebAppContext_War() {
		return webAppContext_War;
	}

	public String getTempDirectory() {
		return tempDirectory;
	}

	public void setConnector_port(String connector_port) {
		this.connector_port = connector_port;
	}

	public void setContextPath(String contextPath) {
		this.contextPath = contextPath;
	}

	public void setTempDirectory(String tempDirectory) {
		this.tempDirectory = tempDirectory;
	}

	public void setUserRealmName(String userRealmName) {
		this.userRealmName = userRealmName;
	}

	public void setUserRealmPath(String userRealmPath) {
		this.userRealmPath = userRealmPath;
	}

	public void setWebAppContext_War(String webAppContext_War) {
		this.webAppContext_War = webAppContext_War;
	}


}
