/*
 * Created on 2006/12/26
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.printer.gui.editor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTablePrintMIB;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.socket.ConnectionNetworkPrinterInfo;
import netjfwatcher.engine.socket.ConnectionNodeSnmpGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.PrintMibInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.preference.SnmpPreference;
import netwatcher.printer.preference.PrinterPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * Printerm[h̏Ԃ\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorPrinterNodeStatusView extends AbstractEditorNodeView {
	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " Printer Node View";

	private Text lowPaperText;

	private Text noPaperText;

	private Text lowTonerText;

	private Text noTonerText;

	private Text doorOpenText;

	private Text jammedText;

	private Text offlineText;

	private Text serviceRequestedText;

	private Text inputTrayMissingText;

	private Text outputTrayMissingText;

	private Text markerSupplyMissingText;

	private Text outputNearFullText;

	private Text outputFullText;

	private Text inputTrayEmptyText;

	private Text overduePreventMaintText;

	private static Color RED_COLOR = new Color(null, 255, 0, 0);

	private static final int COMBO_TEXT_WIDTH1 = 70;

	private static final int TEXT_WIDTH1 = 120;

	private static final int WIDTH_TEXT_WIDTH1 = 300;

	private static final int STATUS_TEXT_WIDTH1 = 12;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	/* Horizontal Span 2 */
	private static final int HORIZONTAL_SPAN2 = 2;

	/* Logging */
	private static Logger logger;

	/* m[hĎ */
	private NodeInformation targetNodeInfo;

	private int hrDeviceSelectIndex = 0;

	private Button refreshButton;

	private Button getMibButton;

	/* m[heLXg\BackGroundFi[ */
	private Color textBackColor;

	private Combo hrDeviceIndexCombo;

	private Text hrDeviceTypeText;

	private Text hrDeviceDescrText;

	private Text hrDeviceIDText;

	private Text hrDeviceStatusText;

	private Text hrDeviceErrorsText;

	private Text hrPrinterStatusText;

	private Text hrPrinterDetectedErrorStateText;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorPrinterNodeStatusView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = WHITE_COLOR;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayoutBase = new GridLayout(1, true);
		Composite compositeBase = new Composite(scrollComposite, SWT.NONE);
		compositeBase.setLayout(gridLayoutBase);
		compositeBase.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		GridLayout gridLayoutHrDevice = new GridLayout(4, false);
		Composite compositeHrDevice = new Composite(compositeBase, SWT.NONE);
		compositeHrDevice.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));
		compositeHrDevice.setLayout(gridLayoutHrDevice);

		GridLayout gridLayoutStatus = new GridLayout(8, false);
		Composite compositeStatus = new Composite(compositeBase, SWT.NULL);
		compositeStatus.setLayout(gridLayoutStatus);
		compositeStatus.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_FILL));

		Label label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceIndex");
		gridData = new GridData();
		label.setLayoutData(gridData);

		hrDeviceIndexCombo = new Combo(compositeHrDevice, SWT.DROP_DOWN
				| SWT.READ_ONLY);
		hrDeviceIndexCombo.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COMBO_TEXT_WIDTH1;
		hrDeviceIndexCombo.setLayoutData(gridData);

		/* Button */
		refreshButton = new Button(compositeHrDevice, SWT.NONE);
		refreshButton.setText("Refresh");

		getMibButton = new Button(compositeHrDevice, SWT.NONE);
		getMibButton.setText("Print MIB Get");
		getMibButton.setLayoutData(new GridData());

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceType");
		gridData = new GridData();
		label.setLayoutData(gridData);

		hrDeviceTypeText = new Text(compositeHrDevice, SWT.BORDER
				| SWT.READ_ONLY);
		hrDeviceTypeText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDTH_TEXT_WIDTH1;
		hrDeviceTypeText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceDescr");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrDeviceDescrText = new Text(compositeHrDevice, SWT.BORDER
				| SWT.READ_ONLY);
		hrDeviceDescrText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = WIDTH_TEXT_WIDTH1;
		hrDeviceDescrText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceID");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrDeviceIDText = new Text(compositeHrDevice, SWT.BORDER | SWT.READ_ONLY);
		hrDeviceIDText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		hrDeviceIDText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceStatus");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrDeviceStatusText = new Text(compositeHrDevice, SWT.BORDER
				| SWT.READ_ONLY);
		hrDeviceStatusText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		hrDeviceStatusText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrDeviceErrors");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrDeviceErrorsText = new Text(compositeHrDevice, SWT.BORDER
				| SWT.READ_ONLY);
		hrDeviceErrorsText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		hrDeviceErrorsText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrPrinterStatus");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrPrinterStatusText = new Text(compositeHrDevice, SWT.BORDER
				| SWT.READ_ONLY);
		hrPrinterStatusText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		hrPrinterStatusText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("hrPrinterDetectedErrorState");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		hrPrinterDetectedErrorStateText = new Text(compositeHrDevice,
				SWT.BORDER | SWT.READ_ONLY);
		hrPrinterDetectedErrorStateText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		hrPrinterDetectedErrorStateText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(compositeHrDevice, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		setStatusText(compositeStatus);

		scrollComposite.setContent(compositeBase);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setHrDeviceIndexCombo();
		setTextNodeInfo(getPrintMibInfo(hrDeviceSelectIndex));

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				try {
					setHrDeviceIndexCombo();
					setTextNodeInfo(getPrintMibInfo(hrDeviceSelectIndex));
				} finally {
					refreshButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		getMibButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				getMibButton.setEnabled(false);

				try {
					getPrintMib();
					setHrDeviceIndexCombo();
					setTextNodeInfo(getPrintMibInfo(hrDeviceSelectIndex));
				} finally {
					getMibButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		hrDeviceIndexCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {

				if (hrDeviceIndexCombo.getSelectionIndex() >= 0) {
					hrDeviceSelectIndex = hrDeviceIndexCombo.getSelectionIndex();
					setTextNodeInfo(getPrintMibInfo(hrDeviceSelectIndex));
				}
			}
		});
	}

	private void setStatusText(Composite composite1) {

		Label label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.LOW_PAPER);
		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		lowPaperText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		lowPaperText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		lowPaperText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.NO_PAPER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		noPaperText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		noPaperText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		noPaperText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.LOW_TONER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		lowTonerText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		lowTonerText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		lowTonerText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.NO_TONER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		noTonerText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		noTonerText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		noTonerText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.DOOR_OPEN);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		doorOpenText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		doorOpenText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		doorOpenText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.JAMMED);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		jammedText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		jammedText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		jammedText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.OFFLINE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		offlineText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		offlineText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		offlineText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.SERVICE_REQ);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		serviceRequestedText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		serviceRequestedText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		serviceRequestedText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.INPUT_TRAY_MISSING);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		inputTrayMissingText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		inputTrayMissingText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		inputTrayMissingText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.OUTPUT_TRAY_MISSING);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		outputTrayMissingText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		outputTrayMissingText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		outputTrayMissingText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.MARKER_SUPPLY_MISSING);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		markerSupplyMissingText = new Text(composite1, SWT.BORDER
				| SWT.READ_ONLY);
		markerSupplyMissingText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		markerSupplyMissingText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.OUTPUT_NEAR_FULL);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		outputNearFullText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		outputNearFullText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		outputNearFullText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.OUTPUT_FULL);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		outputFullText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		outputFullText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		outputFullText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.INPUT_TRAY_EMPTY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		inputTrayEmptyText = new Text(composite1, SWT.BORDER | SWT.READ_ONLY);
		inputTrayEmptyText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		inputTrayEmptyText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText(PrinterPreference.OVERDUE_PREVENT_MAINT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);
		overduePreventMaintText = new Text(composite1, SWT.BORDER
				| SWT.READ_ONLY);
		overduePreventMaintText.setBackground(textBackColor);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = STATUS_TEXT_WIDTH1;
		overduePreventMaintText.setLayoutData(gridData);
	}

	private void getPrintMib() {
		if (!isSocket) {
			SnmpPrintMibGet printMibGetInstance = new SnmpPrintMibGet();
			printMibGetInstance.setSnmpPrintMibGet(targetNodeInfo
					.getIpaddress(), SnmpPreference.SNMP_VERSION_1,
					targetNodeInfo.getRoCommunity());
			try {
				printMibGetInstance.getPrintMIB();
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", e.getMessage());
				shell.dispose();

			}
		} else {

			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();
			ConnectionNodeSnmpGet refreshNodeSnmp = new ConnectionNodeSnmpGet(
					engineAddress);

			try {
				refreshNodeSnmp.refreshNodeSnmp(targetNodeInfo.getIpaddress());

			} catch (EngineConnectException e) {

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);

				shell.dispose();

			} catch (IOException e) {

				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);

				shell.dispose();

			}
		}
	}

	private ArrayList getPrintMibInfoList() {
		ArrayList nodeSNMPPrintList = null;
		if (!isSocket) {

			try {
				nodeSNMPPrintList = DBTablePrintMIB.getInstance()
						.findSNMPPrint(targetNodeInfo.getIpaddress());

			} catch (SQLException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Abort Node information get", e1
						.getMessage());
				logger.warning("Abort Node information get" + e1.getMessage());
				shell.dispose();
			} catch (Exception e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Abort Node information get", e1
						.getMessage());
				logger.warning("Abort Node information get" + e1.getMessage());
				shell.dispose();
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			try {
				ConnectionNetworkPrinterInfo connectionNetPrint = new ConnectionNetworkPrinterInfo(
						engineAddress);
				nodeSNMPPrintList = connectionNetPrint
						.getPrintMibInfo(targetNodeInfo.getIpaddress());

			} catch (EngineConnectException ex) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + ex.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + ex.getMessage());
				shell.dispose();
				ex.printStackTrace();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			}
		}
		return nodeSNMPPrintList;

	}

	private PrintMibInfo getPrintMibInfo(int index) {

		ArrayList nodeSNMPPrintList = getPrintMibInfoList();
		if (nodeSNMPPrintList == null || nodeSNMPPrintList.size() == 0) {
			return null;
		}
		PrintMibInfo nodePrintMib = null;
		nodePrintMib = (PrintMibInfo) nodeSNMPPrintList.get(index);
		setTextNodeInfo(nodePrintMib);

		return nodePrintMib;
	}

	private void setHrDeviceIndexCombo() {
		hrDeviceIndexCombo.removeAll();
		ArrayList nodeSNMPPrintList = getPrintMibInfoList();
		if (nodeSNMPPrintList == null) {
			return;
		}
		for (int i = 0; i < nodeSNMPPrintList.size(); i++) {
			hrDeviceIndexCombo.add(Integer.toString(i + 1));
		}
		hrDeviceIndexCombo.select(0);
	}

	private void setTextNodeInfo(PrintMibInfo nodePrintMib) {
		if (nodePrintMib == null) {
			return;
		}
		if (nodePrintMib.getHrDeviceType() != null) {
			String hrDeviceType = nodePrintMib.getHrDeviceType();
			if (hrDeviceType.equals(PrinterPreference.HRDEVICE_PRINTER_OID)) {
				hrDeviceType += " (" + PrinterPreference.HRDEVICE_PRINTER_DESC
						+ ")";
			}
			hrDeviceTypeText.setText(hrDeviceType);
		}
		if (nodePrintMib.getHrDeviceDescr() != null) {
			hrDeviceDescrText.setText(nodePrintMib.getHrDeviceDescr());
		}
		if (nodePrintMib.getHrDeviceID() != null) {
			hrDeviceIDText.setText(nodePrintMib.getHrDeviceID());
		}
		if (nodePrintMib.getHrDeviceStatus() != null) {
			String deviceStatusCode = nodePrintMib.getHrDeviceStatus();
			String deviceStatus = "";

			if (deviceStatusCode
					.equals(PrinterPreference.HRDEVICE_STATUS_UNKNOWN_CODE)) {
				deviceStatus = PrinterPreference.HRDEVICE_STATUS_UNKNOWN;
			} else if (deviceStatusCode
					.equals(PrinterPreference.HRDEVICE_STATUS_RUNNING_CODE)) {
				deviceStatus = PrinterPreference.HRDEVICE_STATUS_RUNNING;
			} else if (deviceStatusCode
					.equals(PrinterPreference.HRDEVICE_STATUS_WARNING_CODE)) {
				deviceStatus = PrinterPreference.HRDEVICE_STATUS_WARNING;
			} else if (deviceStatusCode
					.equals(PrinterPreference.HRDEVICE_STATUS_TESTING_CODE)) {
				deviceStatus = PrinterPreference.HRDEVICE_STATUS_TESTING;
			} else if (deviceStatusCode
					.equals(PrinterPreference.HRDEVICE_STATUS_DOWN_CODE)) {
				deviceStatus = PrinterPreference.HRDEVICE_STATUS_DOWN;
			}

			hrDeviceStatusText.setText(deviceStatus);
		}
		if (nodePrintMib.getHrDeviceErrors() != null) {
			hrDeviceErrorsText.setText(nodePrintMib.getHrDeviceErrors());
		}
		if (nodePrintMib.getHrPrinterStatus() != null) {
			String printerStatusCode = nodePrintMib.getHrPrinterStatus();
			String printerStatus = "";
			if (printerStatusCode
					.equals(PrinterPreference.HRPRINTER_STATUS_OTHER_CODE)) {
				printerStatus = PrinterPreference.HRPRINTER_STATUS_OTHER;
			} else if (printerStatusCode
					.equals(PrinterPreference.HRPRINTER_STATUS_UNKNOWN_CODE)) {
				printerStatus = PrinterPreference.HRPRINTER_STATUS_UNKNOWN;
			} else if (printerStatusCode
					.equals(PrinterPreference.HRPRINTER_STATUS_IDLE_CODE)) {
				printerStatus = PrinterPreference.HRPRINTER_STATUS_IDLE;
			} else if (printerStatusCode
					.equals(PrinterPreference.HRPRINTER_STATUS_PRINTING_CODE)) {
				printerStatus = PrinterPreference.HRPRINTER_STATUS_PRINTING;
			} else if (printerStatusCode
					.equals(PrinterPreference.HRPRINTER_STATUS_WARMUP_CODE)) {
				printerStatus = PrinterPreference.HRPRINTER_STATUS_WARMUP;
			}

			hrPrinterStatusText.setText(printerStatus);
		}
		if (nodePrintMib.getHrPrinterDetectedErrorState() != null) {
			String errorState = nodePrintMib.getHrPrinterDetectedErrorState();
			if (errorState.length() < 4) {
				errorState += "00";
			}

			long errorStateCode = convHexToInt(errorState);

			setDetectedErrorCode(errorStateCode);
			hrPrinterDetectedErrorStateText.setText(errorState);
		}

	}

	private void setDetectedErrorCode(long errorStateCode) {
		// System.out.println("errorStateCode " +
		// Long.toHexString(errorStateCode));
		if ((errorStateCode & PrinterPreference.LOW_PAPER_MASK) != 0) {
			lowPaperText.setBackground(RED_COLOR);
		} else {
			lowPaperText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.NO_PAPER_MASK) != 0) {
			noPaperText.setBackground(RED_COLOR);
		} else {
			noPaperText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.LOW_TONER_MASK) != 0) {
			lowTonerText.setBackground(RED_COLOR);
		} else {
			lowTonerText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.NO_TONER_MASK) != 0) {
			noTonerText.setBackground(RED_COLOR);
		} else {
			noTonerText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.DOOR_OPEN_MASK) != 0) {
			doorOpenText.setBackground(RED_COLOR);
		} else {
			doorOpenText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.JAMMED_MASK) != 0) {
			jammedText.setBackground(RED_COLOR);
		} else {
			jammedText.setBackground(textBackColor);
		}

		if ((errorStateCode & PrinterPreference.OFFLINE_MASK) != 0) {
			offlineText.setBackground(RED_COLOR);
		} else {
			offlineText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.SERVICE_REQ_MASK) != 0) {
			serviceRequestedText.setBackground(RED_COLOR);
		} else {
			serviceRequestedText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.INPUT_TRAY_MISSING_MASK) != 0) {
			inputTrayMissingText.setBackground(RED_COLOR);
		} else {
			inputTrayMissingText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.OUTPUT_TRAY_MISSING_MASK) != 0) {
			outputTrayMissingText.setBackground(RED_COLOR);
		} else {
			outputTrayMissingText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.MARKER_SUPPLY_MISSING_MASK) != 0) {
			markerSupplyMissingText.setBackground(RED_COLOR);
		} else {
			markerSupplyMissingText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.OUTPUT_NEAR_FULL_MASK) != 0) {
			outputNearFullText.setBackground(RED_COLOR);
		} else {
			outputNearFullText.setBackground(textBackColor);
		}

		if ((errorStateCode & PrinterPreference.OUTPUT_FULL_MASK) != 0) {
			outputFullText.setBackground(RED_COLOR);
		} else {
			outputFullText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.INPUT_TRAY_EMPTY_MASK) != 0) {
			inputTrayEmptyText.setBackground(RED_COLOR);
		} else {
			inputTrayEmptyText.setBackground(textBackColor);
		}
		if ((errorStateCode & PrinterPreference.OVERDUE_PREVENT_MAINT_MASK) != 0) {
			overduePreventMaintText.setBackground(RED_COLOR);
		} else {
			overduePreventMaintText.setBackground(textBackColor);
		}
	}

	private int convHexToInt(String str) {

		char s[];
		int a, i, r;
		a = 1;
		r = 0;
		s = str.toCharArray();
		for (i = str.length() - 1; i > -1; i--) {
			switch (s[i]) {
			case '0':
				r += a * 0;
				break;
			case '1':
				r += a * 1;
				break;
			case '2':
				r += a * 2;
				break;
			case '3':
				r += a * 3;
				break;
			case '4':
				r += a * 4;
				break;
			case '5':
				r += a * 5;
				break;
			case '6':
				r += a * 6;
				break;
			case '7':
				r += a * 7;
				break;
			case '8':
				r += a * 8;
				break;
			case '9':
				r += a * 9;
				break;
			case 'a':
				r += a * 10;
				break;
			case 'b':
				r += a * 11;
				break;
			case 'c':
				r += a * 12;
				break;
			case 'd':
				r += a * 13;
				break;

			case 'e':
				r += a * 14;
				break;

			case 'f':
				r += a * 15;
				break;

			}

			a *= 16;

		}

		return r;

	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

}
