/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;

public class DBTableManagement
extends DBTableBase {
    public static final String TABLEMANAGEMENT = "tableManagement";
    public static final String IPADDRESS = "ipaddress";
    public static final String TABLE_NAME = "table_name";
    public static final String LIMIT_CHECK = "limit_check";
    public static final String TABLE_CREATE_DATE = "table_create_date";
    public static final String LIMIT_YES = "yes";
    public static final String LIMIT_NO = "no";
    private static Logger logger = null;

    public DBTableManagement() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            this.deleteTable(databaseAccess, TABLEMANAGEMENT);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropTableManagementSequenceSQL());
            databaseAccess.executeUpdate(dataaccessobject.getCreateTableManagementTableSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, TABLEMANAGEMENT);
            this.dropSequence(databaseAccess, dataaccessobject.getDropTableManagementSequenceSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void put(String ipaddress, String tableName, String limitCheck) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sql = "INSERT INTO tableManagement ( ipaddress, table_name, limit_check, table_create_date )VALUES ( '" + ipaddress + "','" + tableName + "','" + limitCheck + "','" + dateformat.format(date) + "' )";
            databaseAccess.executeUpdate(sql);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void delete(String ipaddress, String tableName) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "";
            if (ipaddress != null) {
                this.deleteTargetTable(ipaddress);
                sql = "DELETE from tableManagement where ipaddress='" + ipaddress + "'";
            } else {
                sql = "DELETE from tableManagement where table_name='" + tableName + "'";
            }
            databaseAccess.executeUpdate(sql);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void deleteTargetTable(String ipaddress) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                String sql = "SELECT * from tableManagement where ipaddress='" + ipaddress + "'";
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String tableName = rs.getObject(TABLE_NAME).toString();
                    this.deleteTable(dataaccess, tableName);
                }
            }
            catch (DatabaseConnectionException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                logger.warning(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
    }
}

