/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;

public class DBTableMapLink
extends DBTableBase {
    public static final String NODE_MAPLINK_TABLE = "nodeMapLink_table";
    public static final String NODE_MAPLINK_ID = "id";
    public static final String NODE_X_ADDRESS = "node0address";
    public static final String NODE_Y_ADDRESS = "node1address";
    private static Logger logger = null;

    public DBTableMapLink() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            databaseAccess.executeUpdate(dataaccessobject.getDropNodeMapLinkTableSQL());
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropNodeMapLinkTableSequenceSQL());
            databaseAccess.executeUpdate(dataaccessobject.getCreateNodeMapLinkTableSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            databaseAccess.executeUpdate(dataaccessobject.getDropNodeMapLinkTableSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public boolean updateNodeMapLink(NodeMapLinkInformation nodMapLinkInfo, boolean isDeleteLinkData) throws SQLException, DatabaseConnectionException {
        boolean isSuccess = false;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            ArrayList<String> mapLinkIDList = null;
            String sql = "SELECT * from nodeMapLink_table";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            mapLinkIDList = new ArrayList<String>();
            while (rs.next()) {
                mapLinkIDList.add(rs.getObject(NODE_MAPLINK_ID).toString());
            }
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            if (isDeleteLinkData) {
                int i = 0;
                while (i < mapLinkIDList.size()) {
                    sql = databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby") ? "DELETE from nodeMapLink_table where id = " + mapLinkIDList.get(i) : "DELETE from nodeMapLink_table where id = '" + mapLinkIDList.get(i) + "'";
                    stmt.execute(sql);
                    ++i;
                }
            }
            ArrayList node0AddressList = nodMapLinkInfo.getNode0address();
            ArrayList node1AddressList = nodMapLinkInfo.getNode1address();
            int i = 0;
            while (i < node0AddressList.size()) {
                sql = "INSERT INTO nodeMapLink_table( node0address,node1address )VALUES ( '" + (String)node0AddressList.get(i) + "','" + (String)node1AddressList.get(i) + "' )";
                stmt.executeUpdate(sql);
                ++i;
            }
            isSuccess = true;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
        }
        return isSuccess;
    }

    public NodeMapLinkInformation findAll() throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<String> nodeMapLink0List = new ArrayList<String>();
        ArrayList<String> nodeMapLink1List = new ArrayList<String>();
        try {
            String sql = "SELECT * from nodeMapLink_table";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String nodeX = (String)rs.getObject(NODE_X_ADDRESS);
                if (nodeX == null || nodeX.equals("")) {
                    nodeX = "0";
                }
                nodeMapLink0List.add(nodeX);
                String nodeY = (String)rs.getObject(NODE_Y_ADDRESS);
                if (nodeY == null || nodeY.equals("")) {
                    nodeY = "0";
                }
                nodeMapLink1List.add(nodeY);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
        }
        NodeMapLinkInformation nodeMapLinkInfo = new NodeMapLinkInformation();
        nodeMapLinkInfo.setNode0address(nodeMapLink0List);
        nodeMapLinkInfo.setNode1address(nodeMapLink1List);
        return nodeMapLinkInfo;
    }

    public void deleteNode(String ipaddress) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                String sql = "DELETE from nodeMapLink_table where node0address='" + ipaddress + "'";
                databaseAccess.executeUpdate(sql);
                sql = "DELETE from nodeMapLink_table where node1address='" + ipaddress + "'";
                databaseAccess.executeUpdate(sql);
                logger.info("Node Map Link Delete IP=" + ipaddress);
            }
            catch (DatabaseConnectionException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (SQLException ex) {
                logger.warning(ex.getMessage());
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }
}

