/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.PrintMibInfo;

public final class DBTablePrintMIB
extends DBTableBase {
    public static final String SNMP_PRINT_TABLE_NAME = "_print";
    public static final String HR_DEVICE_INDEX = "hrDeciceIndex";
    public static final String HR_DEVICE_TYPE = "hrDeviceType";
    public static final String HR_DEVICE_DESC = "hrDeviceDescr";
    public static final String HR_DEVICE_ID = "hrDeviceID";
    public static final String HR_DEVICE_STATUS = "hrDeviceStatus";
    public static final String HR_DEVICE_ERRORS = "hrDeviceErrors";
    public static final String HR_PRINTER_STATUS = "hrPrinterStatus";
    public static final String HR_PRINTER_DETECTED_ERROR_STATE = "hrPrinterDetectedErrorState";
    public static final String HR_CURDATE = "curdate";
    private static final int COLUMN_HR_DEVICE_INDEX_NO = 0;
    private static final int COLUMN_HR_DEVICE_TYPE_NO = 1;
    private static final int COLUMN_HR_DEVICE_DESC_NO = 2;
    private static final int COLUMN_HR_DEVICE_ID_NO = 3;
    private static final int COLUMN_HR_DEVICE_STATUS_NO = 4;
    private static final int COLUMN_HR_DEVICE_ERRORS_NO = 5;
    private static final int COLUMN_HR_PRINTER_STATUS_NO = 6;
    private static final int COLUMN_HR_PRINTER_DETECTED_ERROR_STATE_NO = 7;
    private static Logger logger = null;
    private static final String SNMP_PRINT_TABLE_ITEM = " (hrDeciceIndex BIGINT , hrDeviceType VARCHAR(255), hrDeviceDescr  VARCHAR(255),hrDeviceID VARCHAR(255),hrDeviceStatus VARCHAR(10),hrDeviceErrors VARCHAR(10),hrPrinterStatus VARCHAR(10),hrPrinterDetectedErrorState VARCHAR(10) ,curdate TIMESTAMP )";
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTablePrintMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void createTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_PRINT_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_PRINT_TABLE_NAME + SNMP_PRINT_TABLE_ITEM);
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(targetIpAddress, String.valueOf(ipaddress) + SNMP_PRINT_TABLE_NAME, "no");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_PRINT_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized ArrayList findSNMPPrint(String tragetIpAddress) throws SQLException, DatabaseConnectionException {
        String convipaddress = "IP" + tragetIpAddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<PrintMibInfo> nodeSNMPPrintList = new ArrayList<PrintMibInfo>();
        try {
            String sql = "SELECT * from " + convipaddress + SNMP_PRINT_TABLE_NAME + " order by " + HR_DEVICE_INDEX + " asc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                PrintMibInfo nodePrintMib = new PrintMibInfo();
                nodePrintMib.setHrDeciceIndex(rs.getObject(HR_DEVICE_INDEX).toString());
                nodePrintMib.setHrDeviceType(rs.getObject(HR_DEVICE_TYPE).toString());
                nodePrintMib.setHrDeviceDescr(rs.getObject(HR_DEVICE_DESC).toString());
                nodePrintMib.setHrDeviceID(rs.getObject(HR_DEVICE_ID).toString());
                nodePrintMib.setHrDeviceStatus(rs.getObject(HR_DEVICE_STATUS).toString());
                nodePrintMib.setHrDeviceErrors(rs.getObject(HR_DEVICE_ERRORS).toString());
                nodePrintMib.setHrPrinterStatus(rs.getObject(HR_PRINTER_STATUS).toString());
                nodePrintMib.setHrPrinterDetectedErrorState(rs.getObject(HR_PRINTER_DETECTED_ERROR_STATE).toString());
                nodeSNMPPrintList.add(nodePrintMib);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        return nodeSNMPPrintList;
    }

    public synchronized void putSNMPPrint(String tragetIpAddress, ArrayList[] interfacesList) throws DatabaseConnectionException, SQLException {
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        String sql = "";
        try {
            try {
                int i = 0;
                while (i < interfacesList[0].size()) {
                    if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                        sql = "insert into " + ipaddressTableName + SNMP_PRINT_TABLE_NAME + "( " + HR_DEVICE_INDEX + ", " + HR_DEVICE_TYPE + ", " + HR_DEVICE_DESC + ", " + HR_DEVICE_ID + ", " + HR_DEVICE_STATUS + ", " + HR_DEVICE_ERRORS + ", " + HR_PRINTER_STATUS + ", " + HR_PRINTER_DETECTED_ERROR_STATE + ", " + HR_CURDATE + " )" + " VALUES( " + ((MibValue)interfacesList[0].get(i)).getMibValue() + "," + "'" + ((MibValue)interfacesList[1].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[2].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[3].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[4].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[5].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[6].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[7].get(i)).getMibValue() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                        databaseAccess.executeUpdate(sql);
                    } else {
                        sql = "insert into " + ipaddressTableName + SNMP_PRINT_TABLE_NAME + "( " + HR_DEVICE_INDEX + ", " + HR_DEVICE_TYPE + ", " + HR_DEVICE_DESC + ", " + HR_DEVICE_ID + ", " + HR_DEVICE_STATUS + ", " + HR_DEVICE_ERRORS + ", " + HR_PRINTER_STATUS + ", " + HR_PRINTER_DETECTED_ERROR_STATE + ", " + HR_CURDATE + " )" + " VALUES( " + "'" + ((MibValue)interfacesList[0].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[1].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[2].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[3].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[4].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[5].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[6].get(i)).getMibValue() + "'," + "'" + ((MibValue)interfacesList[7].get(i)).getMibValue() + "'," + "'" + this.simpleDateformat.format(date) + "'" + ")";
                        databaseAccess.executeUpdate(sql);
                    }
                    ++i;
                }
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw ex;
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress + " SQL=" + sql);
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void updateSNMPPrint(String tragetIpAddress, ArrayList[] interfacesArrayList) throws DatabaseConnectionException, SQLException {
        this.checkPrintMib(tragetIpAddress, interfacesArrayList);
        String ipaddressTablename = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTablename = ipaddressTablename.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                this.updatePrintTabel(databaseAccess, interfacesArrayList, ipaddressTablename);
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " IP=" + tragetIpAddress);
                ex.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + tragetIpAddress);
                e.printStackTrace();
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private void checkPrintMib(String tragetIpAddress, ArrayList[] interfacesArrayList) throws DatabaseConnectionException, SQLException {
        ArrayList preOidList = this.findSNMPPrint(tragetIpAddress);
        if (interfacesArrayList[0].size() != preOidList.size()) {
            String message = "(" + preOidList.size() + "-->" + interfacesArrayList[0].size() + ")";
            this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            logger.info("interfacesList[COLUMN_HR_DEVICE_INDEX_NO].size() : " + interfacesArrayList[0].size());
            logger.info("preOidList.size() : " + preOidList.size());
            int i = 0;
            while (i < interfacesArrayList.length) {
                ArrayList ifList = interfacesArrayList[i];
                int j = 0;
                while (j < ifList.size()) {
                    logger.info("now i=" + i + " j=" + j + " value=" + (String)ifList.get(j));
                    ++j;
                }
                ++i;
            }
            this.deleteIfIndex(tragetIpAddress, preOidList);
            this.putSNMPPrint(tragetIpAddress, interfacesArrayList);
            return;
        }
        int oidCount = 0;
        while (oidCount < interfacesArrayList[0].size()) {
            String hrDeviceErrors;
            String hrDeviceErrorsOld;
            String hrDeviceStatus;
            String hrDeviceStatusOld;
            String hrDeviceID;
            String hrDeviceIDOld;
            String hrDeviceTypeOld;
            String hrDeciceIndex = ((MibValue)interfacesArrayList[0].get(oidCount)).getMibValue();
            String hrDeviceType = ((MibValue)interfacesArrayList[1].get(oidCount)).getMibValue();
            String hrDeviceDescr = ((MibValue)interfacesArrayList[2].get(oidCount)).getMibValue();
            boolean isFoundIfIndex = false;
            PrintMibInfo printMibInfo = null;
            int j = 0;
            while (j < preOidList.size()) {
                printMibInfo = (PrintMibInfo)preOidList.get(j);
                String hrDeciceIndexOld = printMibInfo.getHrDeciceIndex();
                if (hrDeciceIndexOld.equals(hrDeciceIndex)) {
                    isFoundIfIndex = true;
                    break;
                }
                ++j;
            }
            if (!isFoundIfIndex) {
                logger.warning("Not Found hrDeciceIndex " + printMibInfo.getHrDeciceIndex());
                logger.warning("(Detect new hrDeciceIndex=" + hrDeciceIndex + " hrDeviceDescr=" + hrDeviceDescr + "(" + hrDeviceDescr + "))");
                String message = "(Detect new hrDeciceIndex=" + hrDeciceIndex + " hrDeviceDescr=" + hrDeviceDescr + "(" + hrDeviceDescr + "))";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
                this.deleteIfIndex(tragetIpAddress, preOidList);
                this.putSNMPPrint(tragetIpAddress, interfacesArrayList);
                return;
            }
            String hrDeviceDescrOld = printMibInfo.getHrDeviceDescr();
            if (!hrDeviceDescrOld.equals(hrDeviceDescr) && !this.checkInterfaceMIBDataString(hrDeviceDescr, hrDeviceDescrOld)) {
                logger.warning("Old hrDeviceDescr=" + hrDeviceDescrOld + " New hrDeviceDescr=" + hrDeviceDescr);
                String message = "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceDescr : " + hrDeviceDescrOld + "-->" + hrDeviceDescr + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(hrDeviceTypeOld = printMibInfo.getHrDeviceType()).equals(hrDeviceType)) {
                logger.warning("Old hrDeviceType=" + hrDeviceTypeOld + " New hrDeviceType=" + hrDeviceType);
                String message = "(ifIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceType : " + hrDeviceTypeOld + "-->" + hrDeviceType + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(hrDeviceIDOld = printMibInfo.getHrDeviceID()).equals(hrDeviceID = ((MibValue)interfacesArrayList[3].get(oidCount)).getMibValue())) {
                logger.warning("Old hrDeviceStatus=" + hrDeviceIDOld + " New hrDeviceStatus=" + hrDeviceID);
                String message = "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceDescr : " + hrDeviceIDOld + "-->" + hrDeviceID + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(hrDeviceStatusOld = printMibInfo.getHrDeviceStatus()).equals(hrDeviceStatus = ((MibValue)interfacesArrayList[4].get(oidCount)).getMibValue())) {
                logger.warning("Old hrDeviceStatus=" + hrDeviceStatusOld + " New hrDeviceStatus=" + hrDeviceStatus);
                String message = "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceStatus : " + hrDeviceStatusOld + "-->" + hrDeviceStatus + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            if (!(hrDeviceErrorsOld = printMibInfo.getHrDeviceErrors()).equals(hrDeviceErrors = ((MibValue)interfacesArrayList[5].get(oidCount)).getMibValue())) {
                logger.info("Old hrDeviceErrors=" + hrDeviceErrorsOld + " New hrDeviceErrors=" + hrDeviceErrors);
                String message = "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " hrDeviceErrors : " + hrDeviceErrorsOld + "-->" + hrDeviceErrors + ")";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            String hrPrinterStatusOld = printMibInfo.getHrPrinterStatus();
            String hrPrinterStatus = ((MibValue)interfacesArrayList[6].get(oidCount)).getMibValue();
            String hrPrinterDetectedErrorStateOld = printMibInfo.getHrPrinterDetectedErrorState();
            String hrPrinterDetectedErrorState = ((MibValue)interfacesArrayList[7].get(oidCount)).getMibValue();
            if (!hrPrinterStatusOld.equals(hrPrinterStatus) || !hrPrinterDetectedErrorStateOld.equals(hrPrinterDetectedErrorState)) {
                logger.info("(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " " + " (hrPrinterStatus : " + hrPrinterStatusOld + "-->" + hrPrinterStatus + " , hrPrinterDetectedErrorState : " + hrPrinterDetectedErrorStateOld + "-->" + hrPrinterDetectedErrorState + "))");
                String message = "(hrDeciceIndex=" + hrDeciceIndex + " " + hrDeviceDescr + " " + " (hrPrinterStatus : " + hrPrinterStatusOld + "-->" + hrPrinterStatus + " , hrPrinterDetectedErrorState : " + hrPrinterDetectedErrorStateOld + "-->" + hrPrinterDetectedErrorState + "))";
                this.setAlaram(tragetIpAddress, message, interfacesArrayList, preOidList);
            }
            ++oidCount;
        }
    }

    private void setAlaram(String targetIpAddress, String message, ArrayList[] interfacesArrayList, ArrayList preOidList) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngePrintStatus(targetIpAddress, message);
    }

    private void updatePrintTabel(DatabaseAccess databaseAccess, ArrayList[] interfacesArrayList, String ipaddressTablename) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        int i = 0;
        while (i < interfacesArrayList[1].size()) {
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                databaseAccess.executeUpdate("UPDATE " + ipaddressTablename + SNMP_PRINT_TABLE_NAME + " set " + HR_DEVICE_INDEX + "= " + ((MibValue)interfacesArrayList[0].get(i)).getMibValue() + ", " + HR_DEVICE_TYPE + "='" + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + "', " + HR_DEVICE_DESC + "='" + ((MibValue)interfacesArrayList[2].get(i)).getMibValue() + "', " + HR_DEVICE_ID + "='" + ((MibValue)interfacesArrayList[3].get(i)).getMibValue() + "', " + HR_DEVICE_STATUS + "='" + ((MibValue)interfacesArrayList[4].get(i)).getMibValue() + "', " + HR_DEVICE_ERRORS + "='" + ((MibValue)interfacesArrayList[5].get(i)).getMibValue() + "', " + HR_PRINTER_STATUS + "='" + ((MibValue)interfacesArrayList[6].get(i)).getMibValue() + "', " + HR_PRINTER_DETECTED_ERROR_STATE + "='" + ((MibValue)interfacesArrayList[7].get(i)).getMibValue() + "', " + HR_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + HR_DEVICE_INDEX + "= " + ((MibValue)interfacesArrayList[0].get(i)).getMibValue() + " ");
            } else {
                databaseAccess.executeUpdate("UPDATE " + ipaddressTablename + SNMP_PRINT_TABLE_NAME + " set " + HR_DEVICE_INDEX + "='" + ((MibValue)interfacesArrayList[0].get(i)).getMibValue() + "', " + HR_DEVICE_TYPE + "='" + ((MibValue)interfacesArrayList[1].get(i)).getMibValue() + "', " + HR_DEVICE_DESC + "='" + ((MibValue)interfacesArrayList[2].get(i)).getMibValue() + "', " + HR_DEVICE_ID + "='" + ((MibValue)interfacesArrayList[3].get(i)).getMibValue() + "', " + HR_DEVICE_STATUS + "='" + ((MibValue)interfacesArrayList[4].get(i)).getMibValue() + "', " + HR_DEVICE_ERRORS + "='" + ((MibValue)interfacesArrayList[5].get(i)).getMibValue() + "', " + HR_PRINTER_STATUS + "='" + ((MibValue)interfacesArrayList[6].get(i)).getMibValue() + "', " + HR_PRINTER_DETECTED_ERROR_STATE + "='" + ((MibValue)interfacesArrayList[7].get(i)).getMibValue() + "', " + HR_CURDATE + "='" + this.simpleDateformat.format(date) + "'" + " where " + HR_DEVICE_INDEX + "='" + ((MibValue)interfacesArrayList[0].get(i)).getMibValue() + "';");
            }
            ++i;
        }
    }

    public synchronized void deleteIfIndex(String tragetIpAddress, ArrayList preOidList) throws DatabaseConnectionException, SQLException {
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            int i = 0;
            while (i < preOidList.size()) {
                PrintMibInfo nodeview = (PrintMibInfo)preOidList.get(i);
                String ifIndex = nodeview.getHrDeciceIndex();
                String sql = "";
                sql = "DELETE from " + ipaddressTableName + SNMP_PRINT_TABLE_NAME + " where " + HR_DEVICE_INDEX + "=" + "'" + ifIndex + "'";
                databaseAccess.executeUpdate(sql);
                ++i;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private boolean checkInterfaceMIBDataString(String newDataString, String oldDataString) {
        String checkIfDesc;
        int check2;
        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        String databaseKind = resourceset.getResourceInfo().getDatabaseName();
        int checkCode = 63;
        if (databaseKind.equals("MySQL")) {
            checkCode = 63;
        }
        boolean isMuch = false;
        int checkPos = oldDataString.indexOf(checkCode);
        if (checkPos > 0 && (check2 = newDataString.indexOf(checkIfDesc = oldDataString.substring(0, checkPos))) >= 0) {
            isMuch = true;
        }
        return isMuch;
    }

    public static DBTablePrintMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ DBTablePrintMIB(DBTablePrintMIB dBTablePrintMIB) {
        this();
    }

    private static class SingletonResource {
        static final DBTablePrintMIB RESOURCE = new DBTablePrintMIB(null);

        private SingletonResource() {
        }
    }
}

