/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.SystemMib;

public final class DBTableSystemMIB
extends DBTableBase {
    public static final String SNMP_SYS_TABLE_NAME = "_snmp";
    public static final String IPADDRESS = "ipaddress";
    public static final String HOSTNAME = "hostname";
    public static final String COMMUNITY = "community";
    public static final String SYS_DESC = "sysDescr";
    public static final String SYS_OBJECT_ID = "sysObjectID";
    public static final String SYS_UPTIME = "sysUpTime";
    public static final String SYS_CONTACT = "sysContact";
    public static final String SYS_NAME = "sysName";
    public static final String SYS_LOCATION = "sysLocation";
    public static final String SYS_CURDATE = "curdate";
    private static final int SYSTEM_ARRAY_NO = 6;
    private static final int SYSDESC_POS = 0;
    private static final int SYSOBJECT_ID_POS = 1;
    private static final int SYSUPTIME_POS = 2;
    private static final int SYSCONTACT_POS = 3;
    private static final int SYSNAME_POS = 4;
    private static final int SYSLOCATION_POS = 5;
    public static final String SNMP_SYSTEM_TABLE_ITEM = " (ipaddress VARCHAR(15), hostname VARCHAR(255), community VARCHAR(255), sysDescr VARCHAR(255), sysObjectID VARCHAR(255), sysUpTime VARCHAR(255), sysContact VARCHAR(255), sysName VARCHAR(255), sysLocation VARCHAR(255), curdate TIMESTAMP )";
    private static Logger logger = null;
    private final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableSystemMIB() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableSystemMIB getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_SYS_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_SYS_TABLE_NAME + SNMP_SYSTEM_TABLE_ITEM);
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(targetIpAddress, String.valueOf(ipaddress) + SNMP_SYS_TABLE_NAME, "no");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_SYS_TABLE_NAME);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized SystemMib findSystemMIBTable(String ipaddress) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        SystemMib systemMibInfo = null;
        String convIPaddress = "IP" + ipaddress.replace('.', '_');
        convIPaddress = convIPaddress.replace('-', '_');
        try {
            String sql = "SELECT * from " + convIPaddress + SNMP_SYS_TABLE_NAME + " order by " + SYS_CURDATE + " desc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            systemMibInfo = new SystemMib();
            if (rs.next()) {
                systemMibInfo.setSysContact(rs.getObject(SYS_CONTACT).toString());
                systemMibInfo.setSysDescr(rs.getObject(SYS_DESC).toString());
                systemMibInfo.setSysObjectID(rs.getObject(SYS_OBJECT_ID).toString());
                systemMibInfo.setSysLocation(rs.getObject(SYS_LOCATION).toString());
                systemMibInfo.setSysName(rs.getObject(SYS_NAME).toString());
                systemMibInfo.setSysUpTime(rs.getObject(SYS_UPTIME).toString());
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        return systemMibInfo;
    }

    public synchronized void putSystemMIBTable(String tragetIpAddress, String community, String[] value) throws DatabaseConnectionException, SQLException {
        if (value.length != 6) {
            logger.warning("Illegal System MIB count = " + value.length);
            return;
        }
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        String snmptablename = String.valueOf(ipaddressTableName) + SNMP_SYS_TABLE_NAME;
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            String sysDescr = databaseKind.equals("HSQLDB") || databaseKind.equals("Postgresql") || databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby") ? "'" + value[0].replaceAll("'", " ") + "'," : "\"" + value[0] + "\",";
            Date date = Calendar.getInstance().getTime();
            String sysObjectID = value[1];
            String sysContact = value[3];
            String sysName = value[4];
            String sysLocation = value[5];
            databaseAccess.executeUpdate("insert into " + snmptablename + "( " + IPADDRESS + ", " + HOSTNAME + ", " + COMMUNITY + ", " + SYS_DESC + ", " + SYS_OBJECT_ID + ", " + SYS_UPTIME + ", " + SYS_CONTACT + ", " + SYS_NAME + ", " + SYS_LOCATION + ", " + SYS_CURDATE + " )" + " VALUES( " + "'" + tragetIpAddress + "'," + "'" + HOSTNAME + "'," + "'" + community + "'," + sysDescr + "'" + sysObjectID + "'," + "'" + value[2] + "'," + "'" + sysContact + "'," + "'" + sysName + "'," + "'" + sysLocation + "'," + "'" + this.dateformat.format(date) + "'" + ")");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void updateSystemMIBTable(String tragetIpAddress, String community, String[] value) throws DatabaseConnectionException, SQLException {
        if (value.length != 6) {
            logger.warning("Illegal System MIB count = " + value.length);
            return;
        }
        String ipaddressTableName = "IP" + tragetIpAddress.replace('.', '_');
        ipaddressTableName = ipaddressTableName.replace('-', '_');
        String snmptablename = String.valueOf(ipaddressTableName) + SNMP_SYS_TABLE_NAME;
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sysDescrAlarmMessage;
            String sysDescr;
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            SystemMib systemMibInfo = this.findSystemMIBTable(tragetIpAddress);
            String sysDescrOld = "";
            if (databaseKind.equals("HSQLDB") || databaseKind.equals("Postgresql") || databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby")) {
                sysDescr = "'" + value[0].replaceAll("'", " ") + "'";
                if (systemMibInfo != null) {
                    sysDescrOld = "'" + systemMibInfo.getSysDescr().replaceAll("'", " ") + "'";
                }
                sysDescrAlarmMessage = "(sysDescr=" + sysDescrOld + " --> " + sysDescr + ")";
            } else {
                sysDescr = "\"" + value[0] + "\"";
                if (systemMibInfo != null) {
                    sysDescrOld = "\"" + systemMibInfo.getSysDescr() + "\"";
                    sysDescrAlarmMessage = "(sysDescr=" + systemMibInfo.getSysDescr() + " --> " + value[0] + ")";
                } else {
                    sysDescrAlarmMessage = "(sysDescr=? --> " + value[0] + ")";
                }
            }
            String sysObjectID = value[1];
            String sysContact = value[3];
            String sysName = value[4];
            String sysLocation = value[5];
            Date date = Calendar.getInstance().getTime();
            if (systemMibInfo != null) {
                if (!sysDescrOld.equals(sysDescr)) {
                    logger.warning("Detect change of sysDesc. " + sysDescrAlarmMessage);
                    String message = sysDescrAlarmMessage;
                    this.setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysObjectID().equals(sysObjectID)) {
                    logger.warning("Detect change of sysObjectID. Old sysObjectID=" + systemMibInfo.getSysObjectID() + " New sysObjectID=" + sysObjectID);
                    String message = "(sysObjectID : " + systemMibInfo.getSysObjectID() + "-->" + sysObjectID + ")";
                    this.setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysName().equals(sysName)) {
                    logger.warning("Detect change of sysName. Old sysName=" + systemMibInfo.getSysName() + " New sysName=" + sysName);
                    String message = "(sysName : " + systemMibInfo.getSysName() + "-->" + sysName + ")";
                    this.setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysLocation().equals(sysLocation)) {
                    logger.warning("Detect change of sysLocation. Old sysLocation=" + systemMibInfo.getSysLocation() + " New sysLocation=" + sysLocation);
                    String message = "(sysLocation : " + systemMibInfo.getSysLocation() + "-->" + sysLocation + ")";
                    this.setAlaram(tragetIpAddress, message, value, systemMibInfo);
                } else if (!systemMibInfo.getSysContact().equals(sysContact)) {
                    logger.warning("Detect change of sysContact. Old sysContact=" + systemMibInfo.getSysContact() + " New sysContact=" + sysContact);
                    String message = "(sysContact : " + systemMibInfo.getSysContact() + "-->" + sysContact + ")";
                    this.setAlaram(tragetIpAddress, message, value, systemMibInfo);
                }
                databaseAccess.executeUpdate("UPDATE " + snmptablename + " set " + IPADDRESS + "=" + "'" + tragetIpAddress + "', " + HOSTNAME + "=" + "'" + HOSTNAME + "', " + COMMUNITY + "=" + "'" + community + "', " + SYS_DESC + "=" + sysDescr + "," + SYS_OBJECT_ID + "=" + "'" + value[1] + "', " + SYS_UPTIME + "=" + "'" + value[2] + "', " + SYS_CONTACT + "=" + "'" + sysContact + "', " + SYS_NAME + "=" + "'" + sysName + "', " + SYS_LOCATION + "=" + "'" + sysLocation + "', " + SYS_CURDATE + "=" + "'" + this.dateformat.format(date) + "'");
            } else {
                databaseAccess.executeUpdate("INSERT " + snmptablename + " set " + IPADDRESS + "=" + "'" + tragetIpAddress + "', " + HOSTNAME + "=" + "'" + HOSTNAME + "', " + COMMUNITY + "=" + "'" + community + "', " + SYS_DESC + "=" + sysDescr + SYS_UPTIME + "=" + "'" + value[2] + "', " + SYS_CONTACT + "=" + "'" + sysContact + "', " + SYS_NAME + "=" + "'" + sysName + "', " + SYS_LOCATION + "=" + "'" + sysLocation + "', " + SYS_CURDATE + "=" + "'" + this.dateformat.format(date) + "'");
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    private void setAlaram(String tragetIpAddress, String message, String[] value, SystemMib systemMibInfo) {
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setCahngeNodeSystemInfo(tragetIpAddress, message);
    }

    /* synthetic */ DBTableSystemMIB(DBTableSystemMIB dBTableSystemMIB) {
        this();
    }

    private static class SingletonResource {
        static final DBTableSystemMIB RESOURCE = new DBTableSystemMIB(null);

        private SingletonResource() {
        }
    }
}

