/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import netjfwatcher.database.access.model.hsqldb.HsqldbDatabaseManager;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;
import netjfwatcher.database.access.model.hsqldb.HsqldbParams;
import org.eclipse.jface.action.IAction;
import org.hsqldb.Server;

public final class HsqldbControl {
    private static Thread hsqldbServerThread;
    private static Logger logger;
    private HsqldbDatabaseManager manager;

    private HsqldbControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startHsqlDB() throws HsqldbException {
        if (hsqldbServerThread != null) {
            logger.info("Already a HSQLDB server running");
            throw new HsqldbException("Already a HSQLDB server running");
        }
        hsqldbServerThread = new Thread(){

            public void run() {
                String[] args = new String[]{"-database", "hsqldb_data/data", "-dbname", "", "-port", HsqldbParams.getInstance().getPort(), "-no_system_exit", "true"};
                Server.main((String[])args);
            }
        };
        hsqldbServerThread.start();
        logger.info("HSQLDB server start");
    }

    public void stopHsqlDB() throws ClassNotFoundException, SQLException {
        if (hsqldbServerThread == null) {
            return;
        }
        logger.info("HSQLDB server shutdown");
        Connection con = null;
        Statement stmt = null;
        try {
            try {
                Class.forName(HsqldbParams.getInstance().getDriver());
                String url = HsqldbParams.getInstance().getAccessUrl();
                con = DriverManager.getConnection(url, HsqldbParams.getInstance().getUser(), HsqldbParams.getInstance().getPasswd());
                String sql = "SHUTDOWN";
                stmt = con.createStatement();
                stmt.executeUpdate(sql);
            }
            catch (ClassNotFoundException e) {
                logger.warning("ERROR: failed to load HSQLDB JDBC driver. : " + e.getMessage());
                throw e;
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            hsqldbServerThread = null;
        }
    }

    public void startHsqlDBManager(IAction action) {
        if (this.manager != null) {
            return;
        }
        logger.info("HSQLDB manager start");
        this.manager = new HsqldbDatabaseManager();
        this.manager.run(action);
    }

    public void stopHsqlDBManager() {
        if (this.manager == null) {
            return;
        }
        logger.info("HSQLDB manager shutdown");
        try {
            HsqldbDatabaseManager.createEmptyHsqlDatabase();
        }
        catch (ClassNotFoundException e) {
            logger.warning("ERROR: failed to load HSQLDB JDBC driver. : " + e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning("ERROR: failed to stop HSQLDB. : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static HsqldbControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ HsqldbControl(HsqldbControl hsqldbControl) {
        this();
    }

    private static class SingletonResource {
        static final HsqldbControl RESOURCE = new HsqldbControl(null);

        private SingletonResource() {
        }
    }
}

