/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import netjfwatcher.engine.alarm.AlarmCodeInformation;

public final class AlarmMessageQueue {
    public static final int LIMIT = 10;
    private static List<AlarmCodeInformation> alarmQueueList;
    private int writePoint = 0;

    private AlarmMessageQueue() {
        alarmQueueList = Collections.synchronizedList(new LinkedList());
    }

    public synchronized void pushAlarmData(AlarmCodeInformation obj) {
        alarmQueueList.add(this.writePoint, obj);
        ++this.writePoint;
        if (this.writePoint >= 10) {
            this.writePoint = 0;
        }
    }

    public synchronized AlarmCodeInformation popAlarmData(int readPoint) {
        AlarmCodeInformation alarmDataObj = null;
        if (alarmQueueList.size() > 0) {
            alarmDataObj = alarmQueueList.get(readPoint);
        }
        return alarmDataObj;
    }

    public static AlarmMessageQueue getInstance() {
        return SingletonResource.ALARM_MESSAGE_QUEUE;
    }

    public int getWritePoint() {
        return this.writePoint;
    }

    /* synthetic */ AlarmMessageQueue(AlarmMessageQueue alarmMessageQueue) {
        this();
    }

    private static class SingletonResource {
        static final AlarmMessageQueue ALARM_MESSAGE_QUEUE = new AlarmMessageQueue(null);

        private SingletonResource() {
        }
    }
}

