/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm.trap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.trap.AlarmTrapResourceFileParse;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import netjfwatcher.snmpagent.process.AgentTrapPDU;

public class SenderAlarmTrap {
    private static final String DEFAULT_COMMUNITY = "public";
    private static Logger logger;
    private int version;

    private SenderAlarmTrap() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void checkAlarmTrap(String ipAddress, String message, String alarmLevel, String alarmCode) {
        String alarmLevelFilter;
        String trapFlag = AlarmTrapResourceFileParse.getInstance().getAlarmTrapFlag();
        if (trapFlag.equals("true") && this.checkAlarmLevelFilter(alarmLevel, alarmLevelFilter = AlarmTrapResourceFileParse.getInstance().getAlarmTrapLevel())) {
            this.sendTrap(message, alarmLevel, alarmCode);
        }
    }

    private boolean checkAlarmLevelFilter(String alarmLevel, String alarmLevelFilter) {
        boolean isHit = false;
        if (alarmLevelFilter.equals("INFO")) {
            isHit = true;
        } else if (alarmLevelFilter.equals("WARNING")) {
            if (alarmLevel.equals("WARNING") || alarmLevel.equals("ERROR")) {
                isHit = true;
            }
        } else if (alarmLevelFilter.equals("ERROR") && alarmLevel.equals("ERROR")) {
            isHit = true;
        }
        return isHit;
    }

    private void sendTrap(String message, String alarmLevel, String alarmCode) {
        String tragetServerAddress = AlarmTrapResourceFileParse.getInstance().getServerAddress();
        String hostAddress = "";
        String community = DEFAULT_COMMUNITY;
        try {
            InetAddress host = InetAddress.getByName(tragetServerAddress);
            hostAddress = host.getHostAddress();
        }
        catch (UnknownHostException e2) {
            logger.warning("UnknownHostException " + e2.getMessage());
            return;
        }
        this.version = 0;
        try {
            SnmpSequence trapPDUSequence = this.createTrapPDU(hostAddress, community, message, alarmLevel, alarmCode);
            if (trapPDUSequence != null) {
                AgentDispatcher dispacher = new AgentDispatcher();
                dispacher.dispacherTrapSend(hostAddress, this.version, community, trapPDUSequence);
            } else {
                logger.warning("Trap PDU Sequence is null.");
            }
        }
        catch (SocketException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (UnknownHostException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SnmpV3ConfigurationException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (GeneralSecurityException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
    }

    private SnmpSequence createTrapPDU(String hostAddress, String community, String message, String alarmLevel, String alarmCode) {
        SnmpTrapPDU trapPDUSequence = null;
        AgentTrapPDU trapPdu = AgentTrapPDU.getInstance();
        String enterpriseOID = "1.3.6.1.4.1.28018.2";
        String additionalVariableOID = "1.3.6.1.4.1.28018.2";
        int genericTrap = 6;
        int specificTrap = 0;
        if (alarmLevel.equals("INFO")) {
            specificTrap = 0;
            additionalVariableOID = "1.3.6.1.4.1.28018.2.1";
        } else if (alarmLevel.equals("WARNING")) {
            specificTrap = 1;
            additionalVariableOID = "1.3.6.1.4.1.28018.2.2";
        } else if (alarmLevel.equals("ERROR")) {
            specificTrap = 2;
            additionalVariableOID = "1.3.6.1.4.1.28018.2.3";
        }
        String agentIPAddress = "";
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            agentIPAddress = localAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning("UnknownHostException " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        String valueString = message;
        String valueTypeString = "OCTETSTRING";
        try {
            trapPDUSequence = trapPdu.createV1TrapPDU(agentIPAddress, enterpriseOID, genericTrap, specificTrap, additionalVariableOID, valueString, valueTypeString, false);
            logger.info("Sent trap to " + hostAddress);
            logger.info("  enterprise OID:     " + trapPDUSequence.getEnterpriseOID().toString());
            logger.info("  agent address:      " + trapPDUSequence.getAgentAddress().toString());
            logger.info("  generic trap:       " + trapPDUSequence.getGenericTrap());
            logger.info("  specific trap:      " + trapPDUSequence.getSpecificTrap());
            logger.info("  timestamp:          " + trapPDUSequence.getTimestampData());
            logger.info("  supplementary vars: " + trapPDUSequence.getVarBindList().toString());
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        return trapPDUSequence;
    }

    public static SenderAlarmTrap getInstance() {
        return SingletonResource.ALARM_TRAP_INSTANCE;
    }

    /* synthetic */ SenderAlarmTrap(SenderAlarmTrap senderAlarmTrap) {
        this();
    }

    private static class SingletonResource {
        static final SenderAlarmTrap ALARM_TRAP_INSTANCE = new SenderAlarmTrap(null);

        private SingletonResource() {
        }
    }
}

