/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.control;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.CommandException;
import netjfwatcher.engine.command.control.CommandMappingTableController;
import netjfwatcher.engine.command.control.ICommand;
import netjfwatcher.engine.socket.CommandInfo;

public final class ControllerCommand {
    private static Logger logger;

    private ControllerCommand() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static ControllerCommand getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void execute(String id, CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) throws CommandException {
        logger.info(String.valueOf(id) + " Command execute");
        ICommand commandInstance = this.getCommandInstance(id);
        commandInstance.execute(com, ois, oos);
    }

    private synchronized ICommand getCommandInstance(String id) throws CommandException {
        CommandMappingTableController commandMappingTable = CommandMappingTableController.getInstance();
        ICommand commandInstance = commandMappingTable.getCommandInstance(id);
        if (commandInstance == null) {
            logger.warning("Abort Command\u3000Instance : " + id);
            throw new CommandException("Abort Command\u3000Instance : " + id);
        }
        return commandInstance;
    }

    /* synthetic */ ControllerCommand(ControllerCommand controllerCommand) {
        this();
    }

    private static class SingletonResource {
        static final ControllerCommand RESOURCE = new ControllerCommand(null);

        private SingletonResource() {
        }
    }
}

