/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;

public class CommandGarbageCollection
extends TemplateCommandImpl {
    private static Logger logger;

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        GarbageCollectionControl control = com.getGarbageCollectionControlInfo();
        String subCommandCode = control.getCommand();
        GarbageCollectionControl garbageControl = new GarbageCollectionControl();
        if (subCommandCode.equals("Start")) {
            DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();
            try {
                try {
                    gar.createTable();
                }
                catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            finally {
                gar = null;
            }
            GarbageCollectionMemoryJVM.getInstance().setSleepTime(control.getIntervalTime());
            GarbageCollectionMemoryJVM.getInstance().startThread();
            garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
        } else if (subCommandCode.equals("Get")) {
            DBTableGarbageCollection gar = DBTableGarbageCollection.getInstance();
            ArrayList garbageCollectionDataList = null;
            try {
                try {
                    garbageCollectionDataList = gar.findAll(control.getStartTime(), control.getEndTime());
                    garbageControl = gar.getDataCount();
                }
                catch (DatabaseConnectionException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            finally {
                gar = null;
            }
            garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setGarbagCollectionMemoryList(garbageCollectionDataList);
            garbageControl.setIntervalTime(GarbageCollectionMemoryJVM.getInstance().getSleepTime() / 1000L);
        } else if (subCommandCode.equals("Stop")) {
            logger.info("GarbageCollection stop");
            GarbageCollectionMemoryJVM.getInstance().stopThread();
            logger.info("GarbageCollectionMemoryJVM thread stop");
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setThreadState(GarbageCollectionMemoryJVM.getInstance().checkThread());
            logger.info("GarbageCollectionMemoryJVM thread stop thread State : " + GarbageCollectionMemoryJVM.getInstance().checkThread());
        } else {
            logger.warning("Undefined GarbageCollection command : " + subCommandCode);
        }
        this.sendResponse(garbageControl, ois, oos);
    }
}

