/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MibGetResponse;
import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public class CommandMibSet
extends TemplateCommandImpl {
    private static Logger logger;
    private static final int MIB_NAME_POS = 0;
    private static final int MIB_OID_POS = 1;
    private static final int MIB_VALUE_POS = 2;
    private static final int MIB_TYPE_POS = 3;
    private static final int MIB_ACCESS_POS = 4;
    private static final int MIB_ARRAY_LENGTH = 5;
    private ManagerMibTree mibtree;
    private String reportOidDescription = "";

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        String mibSetResult = "OK";
        String ipaddress = com.getIpaddress();
        String community = com.getMibInfo().getRwCommunity();
        String setRequestOID = com.getMibInfo().getRequestMibOid();
        String valueString = com.getMibInfo().getOidSetValue();
        String valueTypeString = com.getMibInfo().getOidType();
        int version = com.getMibInfo().getVersion();
        logger.info("Set OID : " + setRequestOID);
        logger.info("Set Value : " + valueString);
        logger.info("value Type : " + valueTypeString);
        this.mibtree = ManagerMibTree.getInstance();
        AbstractSnmpObject setSnmpObjectInstance = null;
        try {
            setSnmpObjectInstance = this.createSetSnmpObject(setRequestOID, valueTypeString, valueString);
        }
        catch (SnmpSetException e) {
            mibSetResult = e.getMessage();
            MibGetResponseList mibGetResListInstance = new MibGetResponseList();
            mibGetResListInstance.setResultCode(mibSetResult);
            MibGetResponse mibgetresponse = new MibGetResponse();
            mibGetResListInstance.listadd(mibgetresponse);
            this.sendResponse(mibGetResListInstance, ois, oos);
            return;
        }
        if (version == 3 && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(com.getIpaddress()) == null) {
            mibSetResult = "Not found SNMP V3 Agent Address = " + com.getIpaddress();
            logger.warning(mibSetResult);
            MibGetResponseList list = new MibGetResponseList();
            list.setResultCode(mibSetResult);
            MibGetResponse mibgetresponse = new MibGetResponse();
            list.listadd(mibgetresponse);
            this.sendResponse(mibSetResult, ois, oos);
            return;
        }
        logger.info("IP=" + ipaddress + " version=" + version + " Community=" + community);
        this.setrequest(com, ois, oos, setRequestOID, setSnmpObjectInstance, mibSetResult);
    }

    private void setrequest(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos, String setRequestOID, AbstractSnmpObject setSnmpObjectInstance, String mibSetResult) {
        String[] mibPropertyArray;
        block20: {
            MibInfo miboid;
            AbstractSnmpObject responseValue;
            SnmpObjectIdentifier responseOID;
            SnmpSequence responsePair;
            SnmpVarBindList newVars;
            ManagerDispatcher dispacher;
            block19: {
                String ipaddress = com.getIpaddress();
                String community = com.getMibInfo().getRwCommunity();
                int version = com.getMibInfo().getVersion();
                mibPropertyArray = new String[5];
                dispacher = null;
                dispacher = new ManagerDispatcher();
                dispacher.setManagerDispatcher(ipaddress, community, version);
                newVars = dispacher.dispathSetMessage(version, (byte)-93, setRequestOID, setSnmpObjectInstance);
                responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                responseValue = null;
                miboid = this.searchOID(responseOID);
                if (miboid != null) break block19;
                logger.warning("OID " + setRequestOID + " nosuchname.");
                mibSetResult = "OID " + setRequestOID + " nosuchname.";
                MibGetResponseList mibGetResListInstance = new MibGetResponseList();
                mibGetResListInstance.setResultCode(mibSetResult);
                MibGetResponse mibgetresponse = new MibGetResponse();
                mibGetResListInstance.listadd(mibgetresponse);
                this.sendResponse(mibGetResListInstance, ois, oos);
                dispacher.closeConnection();
                return;
            }
            try {
                try {
                    if (!this.checkOID(responseOID.toString())) {
                        responseValue = responsePair.getSNMPObjectAt(1);
                        mibPropertyArray[0] = miboid.getDescrip();
                        mibPropertyArray[1] = responseOID.toString();
                        mibPropertyArray[2] = responseValue.toString();
                        mibPropertyArray[3] = miboid.getSyntax();
                        mibPropertyArray[4] = miboid.getAccess();
                        break block20;
                    }
                    responsePair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                    responseOID = (SnmpObjectIdentifier)responsePair.getSNMPObjectAt(0);
                    responseValue = responsePair.getSNMPObjectAt(1);
                    mibPropertyArray[0] = this.reportOidDescription;
                    mibPropertyArray[1] = responseOID.toString();
                    mibPropertyArray[2] = responseValue.toString();
                    mibPropertyArray[3] = "";
                    mibPropertyArray[4] = "";
                }
                catch (SnmpUnmuchRequestIDException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpUnmuchRequestMsgIDException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (GeneralSecurityException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpV3AuthAbortException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpV3DecryptAbortException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SocketException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpConfigurationException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpV3ConfigurationException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpErrorStatusException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpMIBGetException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpSetException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (SnmpBadValueException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    mibSetResult = e1.getMessage();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                dispacher.closeConnection();
            }
        }
        MibGetResponseList mibGetResListInstance = new MibGetResponseList();
        mibGetResListInstance.setResultCode(mibSetResult);
        MibGetResponse mibgetresponse = new MibGetResponse();
        mibgetresponse.setMibName(mibPropertyArray[0]);
        mibgetresponse.setMibOid(mibPropertyArray[1]);
        mibgetresponse.setMibValue(mibPropertyArray[2]);
        mibgetresponse.setMibType(mibPropertyArray[3]);
        mibgetresponse.setMibAccess(mibPropertyArray[4]);
        mibGetResListInstance.listadd(mibgetresponse);
        this.sendResponse(mibGetResListInstance, ois, oos);
    }

    private MibInfo searchOID(SnmpObjectIdentifier responseOID) {
        MibInfo miboid = null;
        int oidWorkPos = responseOID.toString().lastIndexOf(".");
        String searchOid = responseOID.toString().substring(0, oidWorkPos);
        int i = 0;
        while (i < responseOID.toString().length()) {
            if (this.mibtree.getOidHashMap().containsKey(searchOid)) {
                miboid = (MibInfo)this.mibtree.getOidHashMap().get(searchOid);
                break;
            }
            int checkOidPos = searchOid.lastIndexOf(".");
            if (checkOidPos < 0) break;
            searchOid = searchOid.substring(0, checkOidPos);
            ++i;
        }
        return miboid;
    }

    public boolean checkOID(String checkOID) {
        boolean isCheckReportOID = false;
        if (checkOID.equals("1.3.6.1.6.3.15.1.1.1.0")) {
            this.reportOidDescription = "Unsupported security level";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.2.0")) {
            this.reportOidDescription = "Not in time packet";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.3.0")) {
            this.reportOidDescription = "Unknown user name";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.4.0")) {
            this.reportOidDescription = "Unknown engine ID";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.5.0")) {
            this.reportOidDescription = "Wrong digest";
            isCheckReportOID = true;
        } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.6.0")) {
            this.reportOidDescription = "Descryption error";
            isCheckReportOID = true;
        }
        return isCheckReportOID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractSnmpObject createSetSnmpObject(String setRequestOID, String createValueTypeString, String valueString) throws SnmpSetException {
        String valueTypeString;
        block10: {
            block11: {
                block12: {
                    String oidType;
                    MibInfo miboid;
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        int oidWorkPos = setRequestOID.lastIndexOf(".");
                                                        String searchOid = setRequestOID.substring(0, oidWorkPos);
                                                        miboid = null;
                                                        int i = 0;
                                                        while (i < setRequestOID.length()) {
                                                            if (this.mibtree.getOidHashMap().containsKey(searchOid)) {
                                                                miboid = (MibInfo)this.mibtree.getOidHashMap().get(searchOid);
                                                                break;
                                                            }
                                                            int checkOidPos = searchOid.lastIndexOf(".");
                                                            if (checkOidPos < 0) break;
                                                            searchOid = searchOid.substring(0, checkOidPos);
                                                            ++i;
                                                        }
                                                        valueTypeString = null;
                                                        if (miboid == null) break block11;
                                                        if (!createValueTypeString.equals("Auto")) break block12;
                                                        oidType = miboid.getSyntax();
                                                        if (!oidType.equals("INTEGER")) break block13;
                                                        valueTypeString = "INTEGER";
                                                        break block10;
                                                    }
                                                    if (!oidType.equals("Counter32")) break block14;
                                                    valueTypeString = "COUNTER32";
                                                    break block10;
                                                }
                                                if (!oidType.equals("Counter64")) break block15;
                                                valueTypeString = "COUNTER64";
                                                break block10;
                                            }
                                            if (!oidType.equals("Gauge32")) break block16;
                                            valueTypeString = "GAUGE32";
                                            break block10;
                                        }
                                        if (!oidType.equals("OctetString")) break block17;
                                        valueTypeString = "OCTETSTRING";
                                        break block10;
                                    }
                                    if (!oidType.equals("IpAddress")) break block18;
                                    valueTypeString = "IPADDRESS";
                                    break block10;
                                }
                                if (!oidType.equals("ObjectID")) break block19;
                                valueTypeString = "OBJECTIDENTIFIER";
                                break block10;
                            }
                            if (!oidType.equals("TimeTicks")) break block20;
                            valueTypeString = "TIMETICKS";
                            break block10;
                        }
                        if (!oidType.equals("Uinteger32")) break block21;
                        valueTypeString = "INTEGER32";
                        break block10;
                    }
                    if (oidType.equals("Bits")) {
                        valueTypeString = "BITSTRING";
                        break block10;
                    } else if (oidType.equals("Opaque")) {
                        valueTypeString = "OPAQUE";
                        break block10;
                    } else {
                        if (!oidType.equals("DisplayString")) {
                            logger.warning("Error type " + miboid.getSyntax());
                            throw new SnmpSetException("noAccess OID " + setRequestOID);
                        }
                        valueTypeString = "OCTETSTRING";
                    }
                    break block10;
                }
                valueTypeString = createValueTypeString;
                break block10;
            }
            if (createValueTypeString.equals("Auto")) {
                throw new SnmpSetException("Bad value supplied for OID " + setRequestOID + ".");
            }
            valueTypeString = createValueTypeString;
        }
        AbstractSnmpObject setSnmpObjectInstance = SnmpMappingTableController.getInstance().getSnmpObjectInstance(valueTypeString);
        if (setSnmpObjectInstance == null) throw new SnmpSetException("Illegal SNMP Object Type " + valueTypeString + ".");
        try {
            setSnmpObjectInstance.setValue(valueString);
            return setSnmpObjectInstance;
        }
        catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw new SnmpSetException("Bad value supplied for OID " + setRequestOID + ".");
        }
    }
}

