/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.alarm.EditorAllNodeAlarm;
import netjfwatcher.engine.view.editorpart.alarm.EditorNodeAlarm;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderAlarmList {
    private static Logger logger;
    private IAction editorAlarm = new ActionOpenEditorPartPersonalNodeAlarm();
    private IAction showAllNodeAlarmListTableAction = new ActionOpenEditorPartAllNodeAlarm();
    private IAction editorAlarmSocket = new ActionOpenEditorPartPersonalNodeAlarmSocket();
    private IAction showAllNodeAlarmListTableActionSocket = new ActionOpenEditorPartAllNodeAlarmSocket();
    private IAction showNodeAlarmListTableAction = new ActionShowNodeAlarmListTable();
    private IAction confirmAllAlarmAction = new ActionConfirmAllAlarm();
    private IAction confirmAllAlarmActionSocket = new ActionConfirmAllAlarmSocket();
    private IAction confirmAlarmAction = new ActionConfirmAlarm();
    private IAction confirmAlarmActionSocket = new ActionConfirmAlarmSocket();
    private IAction exportAlarmAction = new ActionExportAlarmInfo();
    private IAction exportAlarmActionSocket = new ActionExportAlarmInfoSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderAlarmList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionShowAllNodeAlarmListTable() {
        return this.showAllNodeAlarmListTableAction;
    }

    public IAction getActionShowAllNodeAlarmListTableSocket() {
        return this.showAllNodeAlarmListTableActionSocket;
    }

    public IAction getActionOpenEditorPartPersonalNodeAlarm() {
        return this.editorAlarm;
    }

    public IAction getActionOpenEditorPartPersonalNodeAlarmSocket() {
        return this.editorAlarmSocket;
    }

    public IAction getActionShowNodeAlarmListTable() {
        return this.showNodeAlarmListTableAction;
    }

    public IAction getActionConfirmAllAlarm() {
        return this.confirmAllAlarmAction;
    }

    public IAction getActionConfirmAllAlarmSocket() {
        return this.confirmAllAlarmActionSocket;
    }

    public IAction getActionConfirmAlarm() {
        return this.confirmAlarmAction;
    }

    public IAction getActionConfirmAlarmSocket() {
        return this.confirmAlarmActionSocket;
    }

    public IAction getActionExportAlarm() {
        return this.exportAlarmAction;
    }

    public IAction getActionExportAlarmSocket() {
        return this.exportAlarmActionSocket;
    }

    protected void refreshNodeAlarmTable() {
    }

    public void writeCSVFile(String ipAddress, String csvFile, boolean isSocket) {
        FileOutputStream fo = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            try {
                ArrayList alarmInfoList = this.getAlarmList(ipAddress, null, null, isSocket);
                if (alarmInfoList != null) {
                    fo = new FileOutputStream(csvFile);
                    osw = new OutputStreamWriter(fo);
                    bw = new BufferedWriter(osw);
                    int j = 0;
                    while (j < alarmInfoList.size()) {
                        AlarmInformation alarmInfo = (AlarmInformation)alarmInfoList.get(j);
                        bw.write(String.valueOf(alarmInfo.getAlarmDate()) + "," + alarmInfo.getNodename() + "," + alarmInfo.getIpaddress() + "," + alarmInfo.getAlarmMessage() + ",");
                        bw.newLine();
                        bw.flush();
                        ++j;
                    }
                }
            }
            catch (SQLException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
                e.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        logger.warning(e2.getMessage());
                        e2.printStackTrace();
                        return;
                    }
                }
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException e3) {
                        logger.warning(e3.getMessage());
                        e3.printStackTrace();
                        return;
                    }
                }
                if (fo != null) {
                    try {
                        fo.close();
                    }
                    catch (IOException e4) {
                        logger.warning(e4.getMessage());
                        e4.printStackTrace();
                        return;
                    }
                }
                return;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    public ArrayList getAlarmList(String ipAddress, String sortColumn, String sortDirection, boolean isSocket) throws DatabaseConnectionException, SQLException {
        ArrayList alarmInfoList = null;
        if (!isSocket) {
            DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
            alarmInfoList = alarmDBTable.findAllAlarm(0, ipAddress, sortColumn, sortDirection);
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionAlarmInformation connectAlarmInfo = new ConnectionAlarmInformation(engineAddress);
            try {
                alarmInfoList = connectAlarmInfo.getAlarmInformationList(0, ipAddress, null, null);
            }
            catch (EngineConnectException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e.getMessage());
                logger.warning("Node List import error" + e.getMessage());
                shell.dispose();
                e.printStackTrace();
            }
        }
        return alarmInfoList;
    }

    private abstract class AbstractAlarmListAction
    extends Action {
        private AbstractAlarmListAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    protected class ActionOpenEditorPartAllNodeAlarm
    extends AbstractAlarmListAction {
        protected ActionOpenEditorPartAllNodeAlarm() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm.gif"));
        }

        public String getText() {
            return "All Node Alarm";
        }

        public String getToolTipText() {
            return "All Node Alarm";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(" All Alarm View", null, false), EditorAllNodeAlarm.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected class ActionOpenEditorPartAllNodeAlarmSocket
    extends ActionOpenEditorPartAllNodeAlarm {
        protected ActionOpenEditorPartAllNodeAlarmSocket() {
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(" All Alarm View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), null, true), EditorAllNodeAlarm.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionOpenEditorPartPersonalNodeAlarm
    extends AbstractAlarmListAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm.gif"));
        }

        public String getText() {
            return "Node Alarm";
        }

        public String getToolTipText() {
            return "Node Alarm";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Alarm View", this.nodeInfo, false), EditorNodeAlarm.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionOpenEditorPartPersonalNodeAlarmSocket
    extends ActionOpenEditorPartPersonalNodeAlarm {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Alarm View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true), EditorNodeAlarm.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected class ActionShowNodeAlarmListTable
    extends AbstractAlarmListAction {
        protected ActionShowNodeAlarmListTable() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm.gif"));
        }

        public String getText() {
            return "Node Alarm";
        }

        public String getToolTipText() {
            return "Node Alarm";
        }

        protected void doTask() {
            ActionBuilderAlarmList.this.refreshNodeAlarmTable();
        }
    }

    public class ActionConfirmAlarm
    extends AbstractAlarmListAction {
        protected String confirmAlarmID;
        protected String confirmIPAddress;

        public void setConfirmAlarm(String alarmID, String confirmIPAddress) {
            this.confirmAlarmID = alarmID;
            this.confirmIPAddress = confirmIPAddress;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm.gif"));
        }

        public String getText() {
            return "Confirm alarm";
        }

        public String getToolTipText() {
            return "Confirm alarm";
        }

        protected void doTask() {
            if (this.confirmAlarmID != null && this.confirmIPAddress != null) {
                logger.info("Confirm Alarm ID = " + this.confirmAlarmID);
                DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
                try {
                    alarmDBTable.updateAlarmIDConfirm(this.confirmIPAddress, this.confirmAlarmID);
                    ActionBuilderAlarmList.this.refreshNodeAlarmTable();
                }
                catch (SQLException e) {
                    logger.warning("Alarm table access error : " + e.getMessage());
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
                catch (DatabaseConnectionException e) {
                    logger.warning("Alarm table access error : " + e.getMessage());
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
                this.confirmAlarmID = null;
                this.confirmIPAddress = null;
            }
        }
    }

    public class ActionConfirmAlarmSocket
    extends ActionConfirmAlarm {
        protected void doTask() {
            if (this.confirmAlarmID != null && this.confirmIPAddress != null) {
                logger.info("Confirm Alarm ID = " + this.confirmAlarmID);
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                try {
                    ConnectionAlarmInformation connection = new ConnectionAlarmInformation(engineAddress);
                    connection.confirmAlarmId(this.confirmIPAddress, this.confirmAlarmID);
                }
                catch (EngineConnectException e) {
                    logger.warning("Alarm table access error : " + e.getMessage());
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
                catch (IOException e) {
                    logger.warning("Alarm table access error : " + e.getMessage());
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
                catch (Exception e) {
                    logger.warning("Alarm table access error : " + e.getMessage());
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
                this.confirmAlarmID = null;
                this.confirmIPAddress = null;
            }
        }
    }

    public class ActionConfirmAllAlarm
    extends AbstractAlarmListAction {
        protected String confirmIPAddress;

        public void setAlarmIPAddress(String confirmIPAddress) {
            this.confirmIPAddress = confirmIPAddress;
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm.gif"));
        }

        public String getText() {
            return "Confirm all alarm";
        }

        public String getToolTipText() {
            return "Confirm all alarm";
        }

        protected void doTask() {
            block6: {
                Shell shell = new Shell();
                try {
                    if (!MessageDialog.openQuestion((Shell)shell, (String)"Confirm", (String)"All alarm confirm ?") || this.confirmIPAddress == null) break block6;
                    DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
                    try {
                        alarmDBTable.updateAllAlarmIDConfirm(this.confirmIPAddress);
                        ActionBuilderAlarmList.this.refreshNodeAlarmTable();
                    }
                    catch (SQLException e) {
                        logger.warning("Alarm table access error : " + e.getMessage());
                        e.printStackTrace();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    }
                    catch (DatabaseConnectionException e) {
                        logger.warning("Alarm table access error : " + e.getMessage());
                        e.printStackTrace();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    }
                    this.confirmIPAddress = null;
                }
                finally {
                    shell.dispose();
                }
            }
        }
    }

    public class ActionConfirmAllAlarmSocket
    extends ActionConfirmAllAlarm {
        protected void doTask() {
            block8: {
                Shell shell = new Shell();
                try {
                    if (!MessageDialog.openQuestion((Shell)shell, (String)"Confirm", (String)"All alarm confirm ?")) break block8;
                    if (this.confirmIPAddress != null) {
                        System.out.println("Alarm confirm Socket");
                        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                        System.out.println("EngineAddress : " + engineAddress);
                        try {
                            ConnectionAlarmInformation connection = new ConnectionAlarmInformation(engineAddress);
                            connection.confirmAllAlarmt(this.confirmIPAddress);
                        }
                        catch (EngineConnectException e) {
                            logger.warning("Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                        }
                        catch (IOException e) {
                            logger.warning("Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                        }
                        catch (Exception e) {
                            logger.warning("Alarm table access error : " + e.getMessage());
                            e.printStackTrace();
                            MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                        }
                        ActionBuilderAlarmList.this.refreshNodeAlarmTable();
                    }
                    this.confirmIPAddress = null;
                }
                finally {
                    shell.dispose();
                }
            }
        }
    }

    public class ActionExportAlarmInfo
    extends AbstractAlarmListAction {
        protected String ipAddress;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAlarmList.this.bundle.getEntry("icons/alarm_export.gif"));
        }

        public String getText() {
            return "Export alarm";
        }

        public String getToolTipText() {
            return "Export alarm";
        }

        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 8192);
            String csvFile = openDialog.open();
            logger.info("Alarm traget IP Address : " + this.ipAddress + " ,Open file name : " + csvFile);
            if (csvFile == null) {
                return;
            }
            ActionBuilderAlarmList.this.writeCSVFile(this.ipAddress, csvFile, false);
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }
    }

    public class ActionExportAlarmInfoSocket
    extends ActionExportAlarmInfo {
        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 8192);
            String csvFile = openDialog.open();
            logger.info("Alarm traget IP Address : " + this.ipAddress + ", Open file name : " + csvFile);
            if (csvFile == null) {
                return;
            }
            ActionBuilderAlarmList.this.writeCSVFile(this.ipAddress, csvFile, true);
        }
    }
}

