/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;
import netjfwatcher.database.access.control.ConstructDatabase;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class DatabaseControl {
    private static Logger logger;
    private boolean isDatabaseStart;

    private DatabaseControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startDatabase(boolean isInitFlag) {
        if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("HSQLDB")) {
            try {
                HsqldbControl.getInstance().startHsqlDB();
                logger.info("Hsqldb start.");
            }
            catch (HsqldbException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Abort HSQLDB start ", (String)e.getMessage());
                logger.warning("Abort HSQLDB star " + e.getMessage());
                shell.dispose();
            }
        } else if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby")) {
            try {
                ApacheDerbyNetworkServer.getInstance().startDerbyNetworkServer();
                logger.info("Apache Derby start.");
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Abort start Apache Derby " + e.getMessage()));
                logger.warning("Abort Apache Derby star " + e.getMessage());
                shell.dispose();
            }
        } else if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby") && !ApacheDerbyEmbeddedDerby.getInstance().isEmbeddedDerby()) {
            logger.info("Embedded Apache Derby Start");
            try {
                ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
            }
            catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Abort start Embedded Apache Derby " + e.getMessage()));
                logger.warning("Abort Embedded Apache Derby star " + e.getMessage());
                shell.dispose();
            }
        }
        ConstructDatabase databaseControl = new ConstructDatabase();
        if (isInitFlag) {
            databaseControl.createDatabase();
        }
        databaseControl.createPool();
        if (isInitFlag) {
            databaseControl.createTable();
        }
        this.isDatabaseStart = true;
    }

    public static DatabaseControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    public boolean isDatabaseStart() {
        return this.isDatabaseStart;
    }

    /* synthetic */ DatabaseControl(DatabaseControl databaseControl) {
        this();
    }

    private static class SingletonResource {
        static final DatabaseControl RESOURCE = new DatabaseControl(null);

        private SingletonResource() {
        }
    }
}

