/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class NodeListExport {
    private static Logger logger;

    public NodeListExport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public Document updateDocument(ArrayList nodeInfoList, NodeMapLinkInformation nodMapLinkinfo) {
        Element confElement = new Element("Node_Infomation_Root");
        Document document = new Document(confElement);
        if (nodeInfoList != null && nodeInfoList.size() > 0) {
            Element nodeInfoRoot = new Element("Node");
            Element[] nodeInfo = new Element[nodeInfoList.size()];
            Element[] nodeName = new Element[nodeInfoList.size()];
            Element[] ipAddress = new Element[nodeInfoList.size()];
            Element[] nodeGroup = new Element[nodeInfoList.size()];
            Element[] engineAddress = new Element[nodeInfoList.size()];
            Element[] nodeX = new Element[nodeInfoList.size()];
            Element[] nodeY = new Element[nodeInfoList.size()];
            Element[] nodeKind = new Element[nodeInfoList.size()];
            Element[] pingPeriod = new Element[nodeInfoList.size()];
            Element[] pingThreshold = new Element[nodeInfoList.size()];
            Element[] snmpVersion = new Element[nodeInfoList.size()];
            Element[] snmpLevel = new Element[nodeInfoList.size()];
            Element[] snmpPeriod = new Element[nodeInfoList.size()];
            Element[] snmpROCommunity = new Element[nodeInfoList.size()];
            Element[] snmpRWCommunity = new Element[nodeInfoList.size()];
            Element[] snmpTimeout = new Element[nodeInfoList.size()];
            Element[] httpPeriod = new Element[nodeInfoList.size()];
            Element[] httpPort = new Element[nodeInfoList.size()];
            Element[] httpUrl = new Element[nodeInfoList.size()];
            Element[] httpTimeout = new Element[nodeInfoList.size()];
            Element[] pop3Period = new Element[nodeInfoList.size()];
            Element[] pop3Port = new Element[nodeInfoList.size()];
            Element[] pop3Timeout = new Element[nodeInfoList.size()];
            Element[] pop3User = new Element[nodeInfoList.size()];
            Element[] pop3Password = new Element[nodeInfoList.size()];
            Element[] smtpPeriod = new Element[nodeInfoList.size()];
            Element[] smtpPort = new Element[nodeInfoList.size()];
            Element[] smtpTimeout = new Element[nodeInfoList.size()];
            Element[] smtpSendAddress = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopHost = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopPort = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopTimeout = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopUser = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopPassword = new Element[nodeInfoList.size()];
            confElement.addContent((Content)nodeInfoRoot);
            int i = 0;
            while (i < nodeInfoList.size()) {
                NodeInformation nodeInformation = (NodeInformation)nodeInfoList.get(i);
                nodeInfo[i] = new Element("Node_Property");
                nodeName[i] = new Element("NodeName");
                ipAddress[i] = new Element("IPAddress");
                nodeGroup[i] = new Element("Group");
                engineAddress[i] = new Element("EngineAddress");
                nodeX[i] = new Element("Node_X");
                nodeY[i] = new Element("Node_Y");
                nodeKind[i] = new Element("NodeKind");
                pingPeriod[i] = new Element("Ping_Period");
                pingThreshold[i] = new Element("PingThreshHold");
                snmpVersion[i] = new Element("SNMPVersion");
                snmpLevel[i] = new Element("SNMPLevel");
                snmpPeriod[i] = new Element("SNMPPeriod");
                snmpROCommunity[i] = new Element("SNMPROCommunity");
                snmpRWCommunity[i] = new Element("SNMPRWOCommunity");
                snmpTimeout[i] = new Element("SNMPTimeout");
                httpPeriod[i] = new Element("HTTPPeriod");
                httpPort[i] = new Element("HTTPPort");
                httpUrl[i] = new Element("HTTPURL");
                httpTimeout[i] = new Element("HTTPTimeout");
                pop3Period[i] = new Element("Pop3_Period");
                pop3Port[i] = new Element("Pop3_Port");
                pop3Timeout[i] = new Element("Pop3_Timeout");
                pop3User[i] = new Element("Pop3_User");
                pop3Password[i] = new Element("Pop3_Password");
                smtpPeriod[i] = new Element("Smtp_Period");
                smtpPort[i] = new Element("Smtp_Port");
                smtpTimeout[i] = new Element("Smtp_Timeout");
                smtpSendAddress[i] = new Element("Smtp_Send_Address");
                smtpCheckPopHost[i] = new Element("Smtp_Check_Pop3_Host");
                smtpCheckPopPort[i] = new Element("Smtp_Check_Pop3_Port");
                smtpCheckPopTimeout[i] = new Element("Smtp_Check_Pop3_Timeout");
                smtpCheckPopUser[i] = new Element("Smtp_Check_Pop3_User");
                smtpCheckPopPassword[i] = new Element("Smtp_Check_Pop3_Password");
                nodeInfoRoot.addContent((Content)nodeInfo[i]);
                nodeInfo[i].addContent((Content)nodeName[i]);
                nodeInfo[i].addContent((Content)ipAddress[i]);
                nodeInfo[i].addContent((Content)nodeGroup[i]);
                nodeInfo[i].addContent((Content)engineAddress[i]);
                nodeInfo[i].addContent((Content)nodeX[i]);
                nodeInfo[i].addContent((Content)nodeY[i]);
                nodeInfo[i].addContent((Content)nodeKind[i]);
                nodeInfo[i].addContent((Content)pingPeriod[i]);
                nodeInfo[i].addContent((Content)pingThreshold[i]);
                nodeInfo[i].addContent((Content)snmpVersion[i]);
                nodeInfo[i].addContent((Content)snmpLevel[i]);
                nodeInfo[i].addContent((Content)snmpPeriod[i]);
                nodeInfo[i].addContent((Content)snmpROCommunity[i]);
                nodeInfo[i].addContent((Content)snmpRWCommunity[i]);
                nodeInfo[i].addContent((Content)httpPeriod[i]);
                nodeInfo[i].addContent((Content)httpPort[i]);
                nodeInfo[i].addContent((Content)httpTimeout[i]);
                nodeInfo[i].addContent((Content)httpUrl[i]);
                nodeInfo[i].addContent((Content)pop3Period[i]);
                nodeInfo[i].addContent((Content)pop3Port[i]);
                nodeInfo[i].addContent((Content)pop3Timeout[i]);
                nodeInfo[i].addContent((Content)pop3User[i]);
                nodeInfo[i].addContent((Content)pop3Password[i]);
                nodeInfo[i].addContent((Content)smtpPeriod[i]);
                nodeInfo[i].addContent((Content)smtpPort[i]);
                nodeInfo[i].addContent((Content)smtpTimeout[i]);
                nodeInfo[i].addContent((Content)smtpSendAddress[i]);
                nodeInfo[i].addContent((Content)smtpCheckPopHost[i]);
                nodeInfo[i].addContent((Content)smtpCheckPopPort[i]);
                nodeInfo[i].addContent((Content)smtpCheckPopTimeout[i]);
                nodeInfo[i].addContent((Content)smtpCheckPopUser[i]);
                nodeInfo[i].addContent((Content)smtpCheckPopPassword[i]);
                nodeName[i].setText(nodeInformation.getNodename());
                ipAddress[i].setText(nodeInformation.getIpaddress());
                nodeGroup[i].setText(nodeInformation.getGroup());
                engineAddress[i].setText(nodeInformation.getEngineAddress());
                nodeX[i].setText(nodeInformation.getNodeX());
                nodeY[i].setText(nodeInformation.getNodeY());
                nodeKind[i].setText(nodeInformation.getNodeKind());
                pingPeriod[i].setText(nodeInformation.getPingPeriod());
                pingThreshold[i].setText(nodeInformation.getPingThreshold());
                snmpVersion[i].setText(nodeInformation.getSnmpVersion());
                snmpLevel[i].setText(nodeInformation.getSnmpLevel());
                snmpPeriod[i].setText(nodeInformation.getSnmpPeriod());
                snmpROCommunity[i].setText(nodeInformation.getRoCommunity());
                snmpRWCommunity[i].setText(nodeInformation.getRwCommunity());
                httpPeriod[i].setText(nodeInformation.getHttpPeriod());
                httpPort[i].setText(nodeInformation.getHttpPort());
                httpTimeout[i].setText(nodeInformation.getHttpTimeout());
                httpUrl[i].setText(nodeInformation.getHttpUrl());
                pop3Period[i].setText(nodeInformation.getPopPeriod());
                pop3Port[i].setText(nodeInformation.getPopPort());
                pop3Timeout[i].setText(nodeInformation.getPopTimeout());
                pop3User[i].setText(nodeInformation.getPopUser());
                pop3Password[i].setText(nodeInformation.getPopPassword());
                smtpPeriod[i].setText(nodeInformation.getSmtpPeriod());
                smtpPort[i].setText(nodeInformation.getSmtpPort());
                smtpTimeout[i].setText(nodeInformation.getSmtpTimeout());
                smtpSendAddress[i].setText(nodeInformation.getSmtpSendAddress());
                smtpCheckPopHost[i].setText(nodeInformation.getSmtpCheckHost());
                smtpCheckPopPort[i].setText(nodeInformation.getSmtpCheckPort());
                smtpCheckPopTimeout[i].setText(nodeInformation.getSmtpCheckTimeout());
                smtpCheckPopUser[i].setText(nodeInformation.getSmtpCheckUser());
                smtpCheckPopPassword[i].setText(nodeInformation.getSmtpCheckPassword());
                ++i;
            }
        }
        if (nodMapLinkinfo != null) {
            ArrayList node0List = nodMapLinkinfo.getNode0address();
            ArrayList node1List = nodMapLinkinfo.getNode1address();
            if (node0List != null && node0List.size() > 0 && node1List != null && node1List.size() > 0) {
                Element linkInfoRoot = new Element("Link");
                confElement.addContent((Content)linkInfoRoot);
                Element[] linkInfo = new Element[node0List.size()];
                Element[] linkX = new Element[node0List.size()];
                Element[] linkY = new Element[node0List.size()];
                int i = 0;
                while (i < node0List.size()) {
                    linkInfo[i] = new Element("Link_Property");
                    linkX[i] = new Element("NodeX");
                    linkY[i] = new Element("NodeY");
                    linkInfoRoot.addContent((Content)linkInfo[i]);
                    linkInfo[i].addContent((Content)linkX[i]);
                    linkInfo[i].addContent((Content)linkY[i]);
                    linkX[i].setText((String)node0List.get(i));
                    linkY[i].setText((String)node1List.get(i));
                    ++i;
                }
            }
        }
        return document;
    }

    public void outputXMLFile(String fileName, Document dom) {
        logger = Logger.getLogger(this.getClass().getName());
        File f = new File(fileName);
        logger.info("Path : " + f.getAbsolutePath());
        if (f == null) {
            return;
        }
        BufferedWriter bufWriter = null;
        try {
            FileWriter fi = new FileWriter(fileName);
            bufWriter = new BufferedWriter(fi);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        try {
            try {
                outputter.output(dom, (OutputStream)System.out);
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}

