/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNetworkCamera;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.socket.CommandInfo;

public final class NodeDelete {
    private static Logger logger;

    private NodeDelete() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void deleteNode(CommandInfo com) {
        logger = Logger.getLogger(this.getClass().getName());
        String ipaddress = com.getIpaddress();
        logger.info("Node Delete IP=" + ipaddress);
        this.removeThreadList(com);
    }

    private void removeThreadList(CommandInfo com) {
        String ipaddress = com.getIpaddress();
        BaseNodeWatchInfoList.getInstance().removeNodeWatchInfo(ipaddress);
        ListQueuePingControl.getInstance().removePingNode(ipaddress);
        ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(ipaddress);
        ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(ipaddress);
        ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);
        ListQueueDatabaseWatchControl.getInstance().removeDatabaseNode(ipaddress);
        DBTableManagement tablemanagement = new DBTableManagement();
        DBTableMapLink tableMapLink = new DBTableMapLink();
        DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();
        DBTableNetworkCamera networkCameraTable = DBTableNetworkCamera.getInstance();
        try {
            nodeRegister.deleteNode(com.getIpaddress());
            tablemanagement.delete(ipaddress, null);
            tableMapLink.deleteNode(ipaddress);
            networkCameraTable.deleteCameraNodeIP(ipaddress);
            DBTableDatabaseWatcher.getInstance().deleteDatabaseWatcherNodeIP(ipaddress);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    public void removeThreadList(String ipaddress) {
        BaseNodeWatchInfoList.getInstance().removeNodeWatchInfo(ipaddress);
        ListQueuePingControl.getInstance().removePingNode(ipaddress);
        ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(ipaddress);
        ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(ipaddress);
        ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);
        DBTableManagement tablemanagement = new DBTableManagement();
        DBTableMapLink tableMapLink = new DBTableMapLink();
        DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();
        DBTableNetworkCamera networkCameraTable = DBTableNetworkCamera.getInstance();
        try {
            nodeRegister.deleteNode(ipaddress);
            tablemanagement.delete(ipaddress, null);
            tableMapLink.deleteNode(ipaddress);
            networkCameraTable.deleteCameraNodeIP(ipaddress);
            DBTableDatabaseWatcher.getInstance().deleteDatabaseWatcherNodeIP(ipaddress);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    public static NodeDelete getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ NodeDelete(NodeDelete nodeDelete) {
        this();
    }

    private static class SingletonResource {
        static final NodeDelete RESOURCE = new NodeDelete(null);

        private SingletonResource() {
        }
    }
}

