/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.map;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeAlarm;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeConfig;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeOperation;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmp;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsSet;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewDraw;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewMouseListener;
import netjfwatcher.engine.nodemaneger.map.NodeMapViewPopUpMenu;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class NodeMapViewPopUpMenuSocket
extends NodeMapViewPopUpMenu {
    private static Logger logger;

    public NodeMapViewPopUpMenuSocket(Display display, Canvas canvas, NodeMapViewDraw mapDraw, NodeMapViewMouseListener mouseListener, SubStatusLineManager statusLineManager) {
        super(display, canvas, mapDraw, mouseListener, statusLineManager);
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setPopUpMenu(Composite parent) {
        this.popUpMenu = new Menu((Decorations)parent.getShell(), 8);
        this.canvas.setMenu(this.popUpMenu);
        MenuItem menuItemLoad = new MenuItem(this.popUpMenu, 8);
        menuItemLoad.setText(LOAD_MENU);
        menuItemLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeMapViewPopUpMenuSocket.this.loadNodeMap();
            }
        });
        MenuItem menuItemSave = new MenuItem(this.popUpMenu, 8);
        menuItemSave.setText(SAVE_MENU);
        menuItemSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell shell;
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                int i = 0;
                while (i < NodeMapViewPopUpMenuSocket.this.nodeMapNodeInfoList.size()) {
                    Shell shell2;
                    NodeMapInfo nodeMapInfo = (NodeMapInfo)NodeMapViewPopUpMenuSocket.this.nodeMapNodeInfoList.get(i);
                    NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
                    ConnectionNodeControl threadstop = new ConnectionNodeControl(engineAddress);
                    try {
                        threadstop.requestThread(nodeInfo.getIpaddress(), "Thread Restart", nodeInfo);
                    }
                    catch (EngineConnectException e1) {
                        shell2 = new Shell();
                        MessageDialog.openError((Shell)shell2, (String)"Node List import error", (String)e1.getMessage());
                        logger.warning("Node List import error" + e1.getMessage());
                        shell2.dispose();
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        shell2 = new Shell();
                        MessageDialog.openError((Shell)shell2, (String)"Node List import error", (String)e1.getMessage());
                        logger.warning("Node List import error" + e1.getMessage());
                        shell2.dispose();
                        e1.printStackTrace();
                    }
                    ++i;
                }
                if (NodeMapViewPopUpMenuSocket.this.nodMapLinkInformationList == null) {
                    return;
                }
                ConnectionNodeMapLink connectNodeInfo = new ConnectionNodeMapLink(engineAddress);
                try {
                    NodeMapViewPopUpMenuSocket.this.nodMapLinkInformationList = connectNodeInfo.updateNodeMapInformation(NodeMapViewPopUpMenuSocket.this.nodMapLinkInformationList);
                }
                catch (EngineConnectException e1) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    logger.warning("Node List import error" + e1.getMessage());
                    shell.dispose();
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    logger.warning("Node List import error" + e1.getMessage());
                    shell.dispose();
                    e1.printStackTrace();
                }
            }
        });
        MenuItem menuItemLink = new MenuItem(this.popUpMenu, 32);
        menuItemLink.setText(LINK_MENU);
        if (this.mouseListener.isLineSelected()) {
            menuItemLink.setSelection(true);
        } else {
            menuItemLink.setSelection(false);
        }
        menuItemLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NodeMapViewPopUpMenuSocket.this.mouseListener.isLineSelected()) {
                    NodeMapViewPopUpMenuSocket.this.mouseListener.setLineSelected(false);
                } else {
                    NodeMapViewPopUpMenuSocket.this.mouseListener.setLineSelected(true);
                }
            }
        });
    }

    protected void setNodeMenu(NodeInformation nodeI) {
        this.nodeViewMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeViewMenuItem.setText("Node Config");
        NodeMapMenuNodeConfig nodeConfig = new NodeMapMenuNodeConfig(nodeI, true);
        this.nodeViewMenuItem.addSelectionListener((SelectionListener)nodeConfig);
        this.nodeAlarmMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeAlarmMenuItem.setText("Node Alarm");
        NodeMapMenuNodeAlarm nodeAlarm = new NodeMapMenuNodeAlarm(nodeI, true);
        this.nodeAlarmMenuItem.addSelectionListener((SelectionListener)nodeAlarm);
        this.nodeSnmpMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeSnmpMenuItem.setText("Node Snmp");
        NodeMapMenuNodeSnmp nodeSnmp = new NodeMapMenuNodeSnmp(nodeI, true);
        this.nodeSnmpMenuItem.addSelectionListener((SelectionListener)nodeSnmp);
        NodePingMenu menuPing = new NodePingMenu();
        menuPing.createPingMenu(this.popUpMenu, nodeI, true);
        NodeSnmpStatisticsMenu menuSnmpStatistics = new NodeSnmpStatisticsMenu();
        menuSnmpStatistics.createSnmpStatisticsMenu(this.popUpMenu, nodeI, true);
        this.nodeSnmpStatisticsSetMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeSnmpStatisticsSetMenuItem.setText("Node Snmp Statistics Set");
        NodeMapMenuNodeSnmpStatisticsSet nodeSnmpStatisticsSet = new NodeMapMenuNodeSnmpStatisticsSet(nodeI, true);
        this.nodeSnmpStatisticsSetMenuItem.addSelectionListener((SelectionListener)nodeSnmpStatisticsSet);
        this.nodeViewMenuItem = new MenuItem(this.popUpMenu, 8);
        this.nodeViewMenuItem.setText("Node Add/Edit/Delete");
        NodeMapMenuNodeOperation nodeOperaqtion = new NodeMapMenuNodeOperation(nodeI, true);
        this.nodeViewMenuItem.addSelectionListener((SelectionListener)nodeOperaqtion);
    }

    protected ArrayList getNodeInfoListMapView(boolean isNodeInfo) {
        if (!isNodeInfo) {
            return new ArrayList();
        }
        ArrayList nodeList = null;
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        try {
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            nodeList = connectNodeInfo.getNodeInformationList(null, null);
            if (nodeList.size() == 0) {
                return nodeList;
            }
        }
        catch (EngineConnectException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + "Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage() + "Engine = " + engineAddress);
            shell.dispose();
            e.printStackTrace();
        }
        catch (IOException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + "Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage() + "Engine = " + engineAddress);
            shell.dispose();
            e.printStackTrace();
        }
        return nodeList;
    }

    private void getNodeMapLink(boolean isNodeMap) {
        if (!isNodeMap) {
            return;
        }
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        try {
            ConnectionNodeMapLink connectNodeInfo = new ConnectionNodeMapLink(engineAddress);
            this.nodMapLinkInformationList = connectNodeInfo.getNodeMapInformation();
        }
        catch (EngineConnectException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + "Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage() + "Engine = " + engineAddress);
            shell.dispose();
            e.printStackTrace();
        }
        catch (IOException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + "Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage() + "Engine = " + engineAddress);
            shell.dispose();
            e.printStackTrace();
        }
    }

    public void loadNodeMap() {
        this.getNodeMapLink(true);
        ArrayList nodeList = this.getNodeInfoListMapView(true);
        this.createNodeMapInfo(nodeList);
        this.mapDraw.redraw(this.nodeMapNodeInfoList, this.nodMapLinkInformationList);
        this.setStatusLine();
    }
}

