/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodewatchinfo;

import java.util.HashMap;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;

public final class StatisticsMibInfo {
    private String targetIpAddress;
    private String nodeName;
    private int version;
    private String community;
    private String snmpLevel;
    private HashMap oidList = new HashMap();

    private StatisticsMibInfo(String targetIpAddress) {
        this.targetIpAddress = targetIpAddress;
    }

    public static StatisticsMibInfo getInstance(String targetIpAddress) {
        StatisticsMibInfo mibNode = null;
        mibNode = ListQueueStatisticsMibControl.getInstance().getStatisticsMibGetNode(targetIpAddress);
        if (mibNode == null) {
            mibNode = new StatisticsMibInfo(targetIpAddress);
        }
        return mibNode;
    }

    public void updateOid(String oid, OidGetInfo oidInfo) {
        this.oidList.put(oid, oidInfo);
    }

    public void removeOid(String oid) {
        this.oidList.remove(oid);
    }

    public void setOidList(String oid, String getMibPeriod, String threshHold, String type) {
        OidGetInfo oidInfo = new OidGetInfo();
        oidInfo.setTargetIpAddress(this.targetIpAddress);
        oidInfo.setVersion(this.version);
        oidInfo.setROCommunity(this.community);
        oidInfo.setTargetOid(oid);
        oidInfo.setGetMibPeriod(getMibPeriod);
        oidInfo.setCountGetMibPeriod(getMibPeriod);
        oidInfo.setThreshHold(threshHold);
        oidInfo.setThreshHoldType(type);
        this.oidList.put(oid, oidInfo);
    }

    public void updateOidList(String oid, String getMibPeriod, String threshHold, String type) {
        OidGetInfo oidGetInfo = new OidGetInfo();
        oidGetInfo.setTargetIpAddress(this.targetIpAddress);
        oidGetInfo.setVersion(this.version);
        oidGetInfo.setROCommunity(this.community);
        oidGetInfo.setTargetOid(oid);
        oidGetInfo.setGetMibPeriod(getMibPeriod);
        oidGetInfo.setCountGetMibPeriod(getMibPeriod);
        oidGetInfo.setThreshHold(threshHold);
        oidGetInfo.setThreshHoldType(type);
        this.oidList.put(oid, oidGetInfo);
    }

    public String getCommunity() {
        return this.community;
    }

    public String getSnmpLevel() {
        return this.snmpLevel;
    }

    public String getTargetIpAddress() {
        return this.targetIpAddress;
    }

    public void setCommunity(String string) {
        this.community = string;
    }

    public void setSnmpLevel(String string) {
        this.snmpLevel = string;
    }

    public HashMap getOidList() {
        return this.oidList;
    }

    public void setOidList(HashMap map) {
        this.oidList = map;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int ver) {
        this.version = ver;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
}

