/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreservationPeriodPreferancePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    public static final int TEXT_WIDTH = 120;
    public static final String PRESERVATION_PERIOD = "Preservation period day";
    public static final String MAX_LINE = "Preservation max line";
    public static final String UNRESTRICTED = "Unrestricted";
    private static final String[] PERIOD = new String[]{"90", "60", "30", "7", "1"};
    private static Logger logger;
    private ResourceInfo info;
    private Combo alarmHoldPeriodDayComb;
    private Text alarmMaxlineText;
    private Combo statisticsHoldPeriodDayComb;
    private Text statisticsMaxLineText;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Group alarmGroup = new Group(composite, 0);
        alarmGroup.setText("Alarm");
        alarmGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        alarmGroup.setLayoutData((Object)gridData);
        Label label = new Label((Composite)alarmGroup, 0);
        label.setText(PRESERVATION_PERIOD);
        label.setLayoutData((Object)new GridData());
        this.alarmHoldPeriodDayComb = new Combo((Composite)alarmGroup, 4);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.alarmHoldPeriodDayComb.setLayoutData((Object)gridData);
        this.alarmHoldPeriodDayComb.add(UNRESTRICTED);
        int i = 0;
        while (i < PERIOD.length) {
            this.alarmHoldPeriodDayComb.add(PERIOD[i]);
            ++i;
        }
        label = new Label((Composite)alarmGroup, 0);
        label.setText(MAX_LINE);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.alarmMaxlineText = new Text((Composite)alarmGroup, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.alarmMaxlineText.setLayoutData((Object)gridData);
        Group statisticsGroup = new Group(composite, 0);
        statisticsGroup.setText("Statistics");
        statisticsGroup.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        statisticsGroup.setLayoutData((Object)gridData);
        label = new Label((Composite)statisticsGroup, 0);
        label.setText(PRESERVATION_PERIOD);
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.statisticsHoldPeriodDayComb = new Combo((Composite)statisticsGroup, 4);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsHoldPeriodDayComb.setLayoutData((Object)gridData);
        this.statisticsHoldPeriodDayComb.add(UNRESTRICTED);
        int i2 = 0;
        while (i2 < PERIOD.length) {
            this.statisticsHoldPeriodDayComb.add(PERIOD[i2]);
            ++i2;
        }
        label = new Label((Composite)statisticsGroup, 0);
        label.setText(MAX_LINE);
        label.setLayoutData((Object)new GridData());
        this.statisticsMaxLineText = new Text((Composite)statisticsGroup, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.statisticsMaxLineText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.setShow();
        this.alarmHoldPeriodDayComb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.statisticsHoldPeriodDayComb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    private void setShow() {
        if (this.info.getAlarmHoldPeriodDay().equals("0")) {
            this.alarmHoldPeriodDayComb.setText(UNRESTRICTED);
        } else {
            this.alarmHoldPeriodDayComb.setText(this.info.getAlarmHoldPeriodDay());
        }
        this.alarmMaxlineText.setText(this.info.getAlarmMax());
        if (this.info.getStatisticsHoldPeriodDay().equals("0")) {
            this.statisticsHoldPeriodDayComb.setText(UNRESTRICTED);
        } else {
            this.statisticsHoldPeriodDayComb.setText(this.info.getStatisticsHoldPeriodDay());
        }
        this.statisticsMaxLineText.setText(this.info.getStatisticsMax());
    }

    protected void performDefaults() {
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.setShow();
    }

    public boolean performOk() {
        if (this.alarmHoldPeriodDayComb.getText().equals(UNRESTRICTED)) {
            this.info.setAlarmHoldPeriodDay("0");
        } else {
            this.info.setAlarmHoldPeriodDay(this.alarmHoldPeriodDayComb.getText());
        }
        this.info.setAlarmMax(this.alarmMaxlineText.getText());
        if (this.statisticsHoldPeriodDayComb.getText().equals(UNRESTRICTED)) {
            this.info.setStatisticsHoldPeriodDay("0");
        } else {
            this.info.setStatisticsHoldPeriodDay(this.statisticsHoldPeriodDayComb.getText());
        }
        this.info.setStatisticsMax(this.statisticsMaxLineText.getText());
        this.saveResourceXMLInfo(this.info);
        return super.performOk();
    }
}

