/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.BusyCheckForPing;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.ping.ExecutePing;

public class ThreadQueueCheckPing
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadQueueCheckPing() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecutePing pingsub = new ExecutePing();
        while (!Thread.interrupted()) {
            NodeWatchInfo nodeExecInfo = QueueForPing.getInstance().popPingQueue();
            NodeWatchInfo nodeCheckIPAddress = null;
            if (nodeExecInfo != null) {
                nodeCheckIPAddress = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(nodeExecInfo.getIpaddress());
            }
            if (nodeExecInfo != null && nodeCheckIPAddress != null) {
                String targetIpAddress = nodeExecInfo.getIpaddress();
                int pingThreshhold = Integer.parseInt(nodeExecInfo.getPingThreshold());
                if (BusyCheckForPing.getInstance().getArbitrationExec(targetIpAddress)) {
                    pingsub.executePing(targetIpAddress, pingThreshhold);
                    BusyCheckForPing.getInstance().release(targetIpAddress);
                } else {
                    logger.warning("Busy Ping IP = " + targetIpAddress);
                }
            }
            nodeExecInfo = null;
            nodeCheckIPAddress = null;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

