/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.BusyCheckForSmtp;
import netjfwatcher.engine.server.protocol.control.QueueForSmtp;
import netjfwatcher.engine.server.protocol.smtp.ExecuteSMTPCheck;

public class ThreadQueueCheckSmtp
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadQueueCheckSmtp() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecuteSMTPCheck checkSmtp = new ExecuteSMTPCheck();
        while (!Thread.interrupted()) {
            NodeWatchInfo info = QueueForSmtp.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;
            if (info != null) {
                checkIPAddress = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(info.getIpaddress());
            }
            if (info != null && checkIPAddress != null) {
                if (BusyCheckForSmtp.getInstance().getArbitrationExec(info.getIpaddress())) {
                    checkSmtp.checkSmtp(info);
                    BusyCheckForSmtp.getInstance().release(info.getIpaddress());
                } else {
                    logger.warning("Busy Smtp IP = " + info.getIpaddress());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

