/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.ping;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;

public class ExecutePing {
    private static Logger logger;
    private PingExcecEngine execPingInstance = new PingExcecEngine(null, null);

    public ExecutePing() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void executePing(String targetIPAddress, int pingThreshold) {
        this.execPingInstance.setTargetIPAddress(targetIPAddress);
        long diffTime = -1L;
        if (this.execPingInstance.checkPingResponse()) {
            AlarmMessageMake message;
            diffTime = this.execPingInstance.getDifftime();
            if (diffTime > (long)pingThreshold) {
                message = AlarmMessageMake.getInstance();
                message.setPingResOver(targetIPAddress, diffTime, pingThreshold);
            } else {
                diffTime = this.execPingInstance.getDifftime();
                if (AlarmRecovery.getInstance().isOccurredAlarmId(targetIPAddress, "3")) {
                    message = AlarmMessageMake.getInstance();
                    message.setRecoveryPingResOver(targetIPAddress, diffTime, pingThreshold);
                }
                if (AlarmRecovery.getInstance().isOccurredAlarmId(targetIPAddress, "1")) {
                    message = AlarmMessageMake.getInstance();
                    message.setRecoveryPingTimeout(targetIPAddress);
                }
            }
        } else {
            diffTime = this.execPingInstance.getDifftime();
        }
        try {
            DBTablePingResponse pingres = DBTablePingResponse.getInstance();
            pingres.putPingTable(targetIPAddress, diffTime);
        }
        catch (DatabaseConnectionException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        logger.fine(String.valueOf(Thread.currentThread().getName()) + " : Ping Response Time : " + Long.toString(diffTime) + "ms");
        try {
            LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(targetIPAddress);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

