/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.snmp;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public class SnmpSystemMibGet {
    private static final String[] SYSTEM_MIB_OID = new String[]{"1.3.6.1.2.1.1.1", "1.3.6.1.2.1.1.2", "1.3.6.1.2.1.1.3", "1.3.6.1.2.1.1.4", "1.3.6.1.2.1.1.5", "1.3.6.1.2.1.1.6"};
    private static Logger logger = null;
    private String[] initialyzeSystemMibValueArray;
    private String[] systemMibValue;
    private String targetIP;
    private int version;
    private String community;
    private DBTableSystemMIB systemMibTable;

    public SnmpSystemMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
        this.systemMibTable = DBTableSystemMIB.getInstance();
        this.initialyzeSystemMibValueArray = new String[SYSTEM_MIB_OID.length];
        this.systemMibValue = new String[SYSTEM_MIB_OID.length];
    }

    public void setSnmpSystemMibGet(String targeIP, int version, String community) {
        this.targetIP = targeIP;
        this.version = version;
        this.community = community;
    }

    public void getInitialyzeSystemMIB() throws SnmpMIBGetException {
        MibGetNextInfo mibGetInstance = null;
        int i = 0;
        try {
            try {
                int checkCount = 0;
                while (mibGetInstance == null) {
                    mibGetInstance = MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(this.targetIP, Thread.currentThread().getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    MibGetNextInfoQueue.getInstance().checkTimeout(this.targetIP, "Initialyze System MIB", ++checkCount, this.version);
                }
                mibGetInstance.setMibGetNext(this.targetIP, this.version, this.community);
                while (i < SYSTEM_MIB_OID.length) {
                    this.initialyzeSystemMibValueArray[i] = mibGetInstance.getMibValueString(SYSTEM_MIB_OID[i]);
                    ++i;
                }
                if (this.initialyzeSystemMibValueArray != null) {
                    this.setInitialyzeDBSystemMIB(this.initialyzeSystemMibValueArray);
                }
            }
            catch (SnmpV3AuthAbortException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
            }
            catch (SnmpV3DecryptAbortException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
            }
            catch (SnmpMIBGetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
                throw e;
            }
            catch (SnmpSetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
            }
            catch (SnmpV3ConfigurationException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP + " : OID=" + SYSTEM_MIB_OID[i]);
                e.printStackTrace();
            }
        }
        finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(this.targetIP, Thread.currentThread().getName());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void getSystemMIB() throws SnmpMIBGetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setInitialyzeDBSystemMIB(String[] value) {
        NodeWatchInfo nodeInfo = null;
        try {
            try {
                this.systemMibTable.putSystemMIBTable(this.targetIP, this.community, value);
                nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(this.targetIP);
                nodeInfo.setSystemMIBStatus("OK");
                BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP);
                e.printStackTrace();
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP);
                e.printStackTrace();
            }
        }
        finally {
            this.systemMibTable = null;
            nodeInfo = null;
        }
    }

    private void setDBSystemMIB(String[] value) {
        try {
            this.systemMibTable.updateSystemMIBTable(this.targetIP, this.community, value);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP);
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(String.valueOf(e.getMessage()) + " :IP=" + this.targetIP);
            e.printStackTrace();
        }
    }
}

